package dev.lydtech.component.framework.kafka;

import java.util.Collections;
import java.util.Properties;

import lombok.extern.slf4j.Slf4j;
import org.apache.kafka.clients.consumer.Consumer;
import org.apache.kafka.clients.consumer.ConsumerConfig;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.apache.kafka.common.serialization.StringDeserializer;

/**
 * Factory class for creating Kafka {@link Consumer}
 */
@Slf4j
public class KafkaConsumerFactory {

    private final String brokerUrl;
    private final String groupId;

    public KafkaConsumerFactory(String brokerUrl, String groupId) {
        this.brokerUrl = brokerUrl;
        this.groupId = groupId;
    }

    public Consumer<Integer, String> createAndSubscribe(String topic) {
        final Properties config = new Properties();

        String extendedGroupId = groupId + topic;
        log.debug("Creating consumer with brokerUrl={}, groupID={} and topic={}", brokerUrl, extendedGroupId, topic);
        config.put(ConsumerConfig.BOOTSTRAP_SERVERS_CONFIG, brokerUrl);
        config.put(ConsumerConfig.GROUP_ID_CONFIG, extendedGroupId);
        config.put(ConsumerConfig.KEY_DESERIALIZER_CLASS_CONFIG, StringDeserializer.class);
        config.put(ConsumerConfig.VALUE_DESERIALIZER_CLASS_CONFIG, StringDeserializer.class);
        config.put(ConsumerConfig.AUTO_OFFSET_RESET_CONFIG, "latest");
        config.put(ConsumerConfig.ENABLE_AUTO_COMMIT_CONFIG, "true");
        // Default is 5 minutes.
        config.put(ConsumerConfig.METADATA_MAX_AGE_CONFIG, 1000);

        Consumer<Integer, String> consumer = new KafkaConsumer<>(config);
        consumer.subscribe(Collections.singletonList(topic));

        log.debug("Kafka consumer is created and subscribed to topic: {}", consumer.subscription());
        return consumer;
    }
}
