/*
 * Decompiled with CFR 0.152.
 */
package dev.lukebemish.dynamicassetgenerator.impl.util;

import dev.lukebemish.dynamicassetgenerator.api.compat.ConditionalInvisibleResourceProvider;
import dev.lukebemish.dynamicassetgenerator.api.compat.InvisibleResourceProvider;
import dev.lukebemish.dynamicassetgenerator.impl.DynamicAssetGenerator;
import java.io.InputStream;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.stream.Stream;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackLocationInfo;
import net.minecraft.server.packs.PackResources;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.metadata.MetadataSectionSerializer;
import net.minecraft.server.packs.repository.PackSource;
import net.minecraft.server.packs.resources.IoSupplier;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

public final class InvisibleProviderUtils {
    public static final List<InvisibleResourceProvider> INVISIBLE_RESOURCE_PROVIDERS = Stream.concat(ServiceLoader.load(InvisibleResourceProvider.class).stream().map(ServiceLoader.Provider::get), ServiceLoader.load(ConditionalInvisibleResourceProvider.class).stream().map(ServiceLoader.Provider::get).filter(ConditionalInvisibleResourceProvider::isAvailable).map(ConditionalInvisibleResourceProvider::get)).toList();

    private InvisibleProviderUtils() {
    }

    public static PackResources constructPlaceholderResourcesFromProvider(final InvisibleResourceProvider provider) {
        return new PackResources(){

            public @Nullable IoSupplier<InputStream> getRootResource(String ... strings) {
                return null;
            }

            public IoSupplier<InputStream> getResource(@NonNull PackType type, @NonNull ResourceLocation location) {
                return provider.getResource(type, location);
            }

            public void listResources(@NonNull PackType packType, @NonNull String namespace, @NonNull String path, // Could not load outer class - annotation placement on inner may be incorrect
            @NonNull PackResources.ResourceOutput resourceOutput) {
                provider.listResources(packType, namespace, path, resourceOutput);
            }

            public @NonNull Set<String> getNamespaces(@NonNull PackType type) {
                return provider.getNamespaces(type);
            }

            public <T> @Nullable T getMetadataSection(@NonNull MetadataSectionSerializer<T> deserializer) {
                return null;
            }

            public PackLocationInfo location() {
                int[] codePoints = provider.getClass().getName().toLowerCase(Locale.ROOT).codePoints().map(i -> Character.isJavaIdentifierPart(i) ? i : 95).toArray();
                return new PackLocationInfo("__placeholder/" + new String(codePoints, 0, codePoints.length), (Component)Component.empty(), PackSource.DEFAULT, Optional.empty());
            }

            public void close() {
            }
        };
    }

    static {
        DynamicAssetGenerator.LOGGER.debug("Loaded invisible resource providers: {}", INVISIBLE_RESOURCE_PROVIDERS);
    }
}

