/*
 * Decompiled with CFR 0.152.
 */
package dev.lukebemish.dynamicassetgenerator.api;

import dev.lukebemish.dynamicassetgenerator.api.ResourceGenerationContext;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.IoSupplier;
import org.jetbrains.annotations.Contract;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

public class TrackingResourceSource
implements ResourceGenerationContext.ResourceSource {
    private final ResourceGenerationContext.ResourceSource delegate;
    private final List<ResourceLocation> touchedTextures = new ArrayList<ResourceLocation>();
    private final Set<ResourceLocation> touchedTexturesSet = new HashSet<ResourceLocation>();
    private final List<ResourceLocation> view = Collections.unmodifiableList(this.touchedTextures);
    private final String prefix;
    private final String suffix;

    public List<ResourceLocation> getTouchedTextures() {
        return this.view;
    }

    private TrackingResourceSource(ResourceGenerationContext.ResourceSource delegate, String prefix, String suffix) {
        this.delegate = delegate;
        this.prefix = prefix.endsWith("/") ? prefix : prefix + "/";
        this.suffix = suffix;
    }

    @Contract(value="_, _, _ -> new")
    public static TrackingResourceSource of(ResourceGenerationContext.ResourceSource delegate, String prefix, String suffix) {
        return new TrackingResourceSource(delegate, prefix, suffix);
    }

    private void addLocation(ResourceLocation location) {
        if (location.getPath().startsWith(this.prefix) && location.getPath().endsWith(this.suffix)) {
            this.unsafeAddLocation(ResourceLocation.fromNamespaceAndPath((String)location.getNamespace(), (String)location.getPath().substring(this.prefix.length(), location.getPath().length() - this.suffix.length())));
        }
    }

    private synchronized void unsafeAddLocation(ResourceLocation location) {
        if (this.touchedTexturesSet.add(location)) {
            this.touchedTextures.add(location);
        }
    }

    @Override
    public @Nullable IoSupplier<InputStream> getResource(@NonNull ResourceLocation location) {
        this.addLocation(location);
        return this.delegate.getResource(location);
    }

    @Override
    public List<IoSupplier<InputStream>> getResourceStack(@NonNull ResourceLocation location) {
        this.addLocation(location);
        return this.delegate.getResourceStack(location);
    }

    @Override
    public Map<ResourceLocation, IoSupplier<InputStream>> listResources(@NonNull String path, @NonNull Predicate<ResourceLocation> filter) {
        Map<ResourceLocation, IoSupplier<InputStream>> resources = this.delegate.listResources(path, filter);
        resources.keySet().forEach(this::addLocation);
        return resources;
    }

    @Override
    public Map<ResourceLocation, List<IoSupplier<InputStream>>> listResourceStacks(@NonNull String path, @NonNull Predicate<ResourceLocation> filter) {
        Map<ResourceLocation, List<IoSupplier<InputStream>>> resources = this.delegate.listResourceStacks(path, filter);
        resources.keySet().forEach(this::addLocation);
        return resources;
    }

    @Override
    public @NonNull Set<String> getNamespaces() {
        return this.delegate.getNamespaces();
    }
}

