/*
 * Decompiled with CFR 0.152.
 */
package dev.lukebemish.dynamicassetgenerator.impl;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonObject;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import dev.lukebemish.dynamicassetgenerator.api.PathAwareInputStreamSource;
import dev.lukebemish.dynamicassetgenerator.api.Resettable;
import dev.lukebemish.dynamicassetgenerator.api.ResourceGenerationContext;
import dev.lukebemish.dynamicassetgenerator.api.ResourceGenerator;
import dev.lukebemish.dynamicassetgenerator.impl.DynamicAssetGenerator;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.IoSupplier;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

public class JsonResourceGeneratorReader
implements PathAwareInputStreamSource,
Resettable {
    private volatile @Nullable Map<ResourceLocation, ResourceGenerator> map = null;
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private final Function<ResourceGenerationContext, Map<ResourceLocation, ResourceGenerator>> mapSupplier = context -> {
        Map map = (Map)mapSupplier.apply((ResourceGenerationContext)context);
        HashMap outMap = new HashMap();
        map.forEach((rl, str) -> {
            try {
                ResourceGenerator json = JsonResourceGeneratorReader.fromJson(str);
                if (json != null && !json.getLocations((ResourceGenerationContext)context).isEmpty()) {
                    json.getLocations((ResourceGenerationContext)context).forEach(localRl -> outMap.put(localRl, json));
                }
            }
            catch (RuntimeException e) {
                DynamicAssetGenerator.LOGGER.error("Could not read json source at {}\n", rl, (Object)e);
            }
        });
        return outMap;
    };

    public JsonResourceGeneratorReader(Function<ResourceGenerationContext, Map<ResourceLocation, String>> mapSupplier) {
    }

    static @Nullable ResourceGenerator fromJson(String json) {
        JsonObject jsonObject = (JsonObject)GSON.fromJson(json, JsonObject.class);
        return (ResourceGenerator)ResourceGenerator.CODEC.parse((DynamicOps)JsonOps.INSTANCE, (Object)jsonObject).getOrThrow();
    }

    @Override
    public @Nullable IoSupplier<InputStream> get(ResourceLocation outRl, ResourceGenerationContext context) {
        this.setupMap(context);
        ResourceGenerator json = this.map.get(outRl);
        if (json != null) {
            return json.get(outRl, context);
        }
        return null;
    }

    @Override
    public @Nullable String createCacheKey(ResourceLocation outRl, ResourceGenerationContext context) {
        this.setupMap(context);
        ResourceGenerator json = this.map.get(outRl);
        if (json != null) {
            return json.createCacheKey(outRl, context);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setupMap(ResourceGenerationContext context) {
        if (this.map == null) {
            JsonResourceGeneratorReader jsonResourceGeneratorReader = this;
            synchronized (jsonResourceGeneratorReader) {
                if (this.map == null) {
                    this.map = this.mapSupplier.apply(context);
                }
            }
        }
    }

    @Override
    public @NonNull Set<ResourceLocation> getLocations(ResourceGenerationContext context) {
        this.setupMap(context);
        return this.map.keySet();
    }

    @Override
    public void reset(ResourceGenerationContext context) {
        this.map = null;
    }

    public static Map<ResourceLocation, String> getSourceJsons(String sourceJsonDirectory, ResourceGenerationContext context) {
        HashMap<ResourceLocation, String> rls = new HashMap<ResourceLocation, String>();
        Map<ResourceLocation, IoSupplier<InputStream>> available = context.getResourceSource().listResources(sourceJsonDirectory, rl -> rl.getPath().endsWith(".json"));
        available.forEach((rl, streamSupplier) -> {
            try (InputStream stream = (InputStream)streamSupplier.get();){
                byte[] bytes = stream.readAllBytes();
                String json = new String(bytes, StandardCharsets.UTF_8);
                rls.put((ResourceLocation)rl, json);
            }
            catch (IOException e) {
                DynamicAssetGenerator.LOGGER.error("Error reading resource source json: " + String.valueOf(rl), (Throwable)e);
            }
        });
        return rls;
    }
}

