/*
 * Decompiled with CFR 0.152.
 */
package dev.lukebemish.dynamicassetgenerator.impl;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import dev.lukebemish.dynamicassetgenerator.api.ResourceCache;
import dev.lukebemish.dynamicassetgenerator.api.ResourceGenerator;
import dev.lukebemish.dynamicassetgenerator.api.generators.DummyGenerator;
import dev.lukebemish.dynamicassetgenerator.impl.BuiltinDataResourceCache;
import dev.lukebemish.dynamicassetgenerator.impl.ModConfig;
import dev.lukebemish.dynamicassetgenerator.impl.platform.Services;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import net.minecraft.SharedConstants;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.metadata.pack.PackMetadataSection;
import net.minecraft.server.packs.repository.Pack;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jspecify.annotations.Nullable;

public class DynamicAssetGenerator {
    public static final Gson GSON = new GsonBuilder().setPrettyPrinting().setLenient().create();
    public static final Gson GSON_FLAT = new GsonBuilder().setLenient().create();
    public static final String MOD_ID = "dynamic_asset_generator";
    public static final String SOURCE_JSON_DIR = "dynamic_asset_generator/generators";
    public static final Logger LOGGER = LogManager.getLogger((String)"dynamic_asset_generator");
    private static @Nullable ModConfig configs;
    public static final boolean TIME_RESOURCES;
    public static final Map<ResourceLocation, PackInfo> CACHES;

    public static PackMetadataSection makeMetadata(ResourceCache cache) {
        return new PackMetadataSection((Component)Component.literal((String)("dynamic_asset_generator/" + String.valueOf(cache.getName()))), SharedConstants.getCurrentVersion().getPackVersion(cache.getPackType()), Optional.empty());
    }

    public static ModConfig getConfig() {
        if (configs == null) {
            configs = ModConfig.get();
        }
        return configs;
    }

    public static void init() {
        ResourceGenerator.register(ResourceLocation.fromNamespaceAndPath((String)MOD_ID, (String)"dummy"), DummyGenerator.CODEC);
        if (TIME_RESOURCES) {
            LOGGER.info("Dynamic Asset Generator will time resource generation during this run!");
            try {
                Files.deleteIfExists(Services.PLATFORM.getModDataFolder().resolve("times.log"));
            }
            catch (IOException e) {
                LOGGER.error("Issue deleting times.log; you might be able to ignore this", (Throwable)e);
            }
        }
        ResourceCache.register(new BuiltinDataResourceCache(ResourceLocation.fromNamespaceAndPath((String)MOD_ID, (String)"builtin_data")), Pack.Position.TOP);
    }

    public static Path cache(ResourceLocation cacheKey, boolean keyed) {
        return Services.PLATFORM.getModDataFolder().resolve(keyed ? "keyed_cache" : "cache").resolve(cacheKey.getNamespace()).resolve(cacheKey.getPath());
    }

    public static void registerCache(ResourceLocation id, ResourceCache cache, Pack.Position position) {
        CACHES.put(id, new PackInfo(cache, position));
    }

    static {
        TIME_RESOURCES = "true".equals(System.getProperty("dynamicassetgenerator.time_resources")) || DynamicAssetGenerator.getConfig().timeResources();
        CACHES = new HashMap<ResourceLocation, PackInfo>();
    }

    public record PackInfo(ResourceCache cache, Pack.Position position) {
    }
}

