/*
 * Decompiled with CFR 0.152.
 */
package dev.lukebemish.dynamicassetgenerator.api.colors;

import dev.lukebemish.dynamicassetgenerator.api.colors.ColorTypes;
import net.minecraft.util.Mth;
import org.jetbrains.annotations.Contract;

public abstract class IntColorType {
    @Contract(pure=true)
    public final int alpha(int color) {
        return color >> 24 & 0xFF;
    }

    @Contract(pure=true)
    protected final int first(int color) {
        return color >> 16 & 0xFF;
    }

    @Contract(pure=true)
    protected final int second(int color) {
        return color >> 8 & 0xFF;
    }

    @Contract(pure=true)
    protected final int third(int color) {
        return color & 0xFF;
    }

    @Contract(pure=true)
    public abstract int toARGB32(int var1);

    @Contract(pure=true)
    public abstract int fromARGB32(int var1);

    @Contract(pure=true)
    public final int color(int alpha, int first, int second, int third) {
        return alpha << 24 | first << 16 | second << 8 | third;
    }

    public static abstract class BlendingIntColorType
    extends IntColorType {
        @Contract(pure=true)
        public int alphaBlend(int over, int under) {
            int aUnder;
            int aOver = this.alpha(over);
            int a = aOver + (aUnder = this.alpha(under)) * (255 - aOver) / 255;
            if (a == 0) {
                return 0;
            }
            int c1 = (this.first(over) * aOver + this.first(under) * aUnder * (255 - aOver) / 255) / a;
            int c2 = (this.second(over) * aOver + this.second(under) * aUnder * (255 - aOver) / 255) / a;
            int c3 = (this.third(over) * aOver + this.third(under) * aUnder * (255 - aOver) / 255) / a;
            return this.color(a, c1, c2, c3);
        }
    }

    public static abstract class HueIntColorType
    extends IntColorType {
        @Contract(pure=true)
        protected abstract float makeChroma(int var1);

        @Contract(pure=true)
        public int hue(int color) {
            return this.first(color);
        }

        @Contract(pure=true)
        private float makeLimitedRed(float chroma, int hue) {
            float hPrime = (float)hue / 42.5f;
            float x = chroma * (1.0f - Math.abs(hPrime % 2.0f - 1.0f));
            if (hPrime < 1.0f) {
                return chroma;
            }
            if (hPrime < 2.0f) {
                return x;
            }
            if (hPrime < 4.0f) {
                return 0.0f;
            }
            if (hPrime < 5.0f) {
                return x;
            }
            return chroma;
        }

        @Contract(pure=true)
        private float makeLimitedGreen(float chroma, int hue) {
            float hPrime = (float)hue / 42.5f;
            float x = chroma * (1.0f - Math.abs(hPrime % 2.0f - 1.0f));
            if (hPrime < 1.0f) {
                return x;
            }
            if (hPrime < 3.0f) {
                return chroma;
            }
            if (hPrime < 4.0f) {
                return x;
            }
            return 0.0f;
        }

        @Contract(pure=true)
        private float makeLimitedBlue(float chroma, int hue) {
            float hPrime = (float)hue / 42.5f;
            float x = chroma * (1.0f - Math.abs(hPrime % 2.0f - 1.0f));
            if (hPrime < 2.0f) {
                return 0.0f;
            }
            if (hPrime < 3.0f) {
                return x;
            }
            if (hPrime < 5.0f) {
                return chroma;
            }
            return x;
        }

        @Contract(pure=true)
        protected abstract float makeMatch(int var1, float var2);

        @Override
        public int toARGB32(int color) {
            float chroma = this.makeChroma(color);
            int hue = this.hue(color);
            float m = this.makeMatch(color, chroma);
            float r = this.makeLimitedRed(chroma, hue) + m;
            float g = this.makeLimitedGreen(chroma, hue) + m;
            float b = this.makeLimitedBlue(chroma, hue) + m;
            return ColorTypes.ARGB32.color(this.alpha(color), Math.round(r * 255.0f) & 0xFF, Math.round(g * 255.0f) & 0xFF, Math.round(b * 255.0f) & 0xFF);
        }

        @Override
        public int fromARGB32(int color) {
            int r = ColorTypes.ARGB32.red(color);
            int g = ColorTypes.ARGB32.green(color);
            int b = ColorTypes.ARGB32.blue(color);
            int xMax = Math.max(Math.max(r, g), b);
            int xMin = Math.min(Math.min(r, g), b);
            int chroma = xMax - xMin;
            int m = xMax == r ? 0 : (xMax == g ? 1 : 2);
            int h = 0;
            float fR = (float)r / 255.0f;
            float fG = (float)g / 255.0f;
            float fB = (float)b / 255.0f;
            float fChroma = (float)chroma / 255.0f;
            if (chroma != 0) {
                float fH = switch (m) {
                    case 0 -> {
                        float value = (fG - fB) / fChroma;
                        if (value < 0.0f) {
                            yield value + 6.0f;
                        }
                        yield value;
                    }
                    case 1 -> (fB - fR) / fChroma + 2.0f;
                    default -> (fR - fG) / fChroma + 4.0f;
                };
                h = Mth.clamp((int)Math.round(fH / 6.0f * 255.0f), (int)0, (int)255);
            }
            return this.makeColor(ColorTypes.ARGB32.alpha(color), h, (float)chroma / 255.0f, (float)xMin / 255.0f, (float)xMax / 255.0f);
        }

        @Contract(pure=true)
        protected abstract int makeColor(int var1, int var2, float var3, float var4, float var5);
    }
}

