/*
 * Decompiled with CFR 0.152.
 */
package dev.lukebemish.dynamicassetgenerator.api.client.generators.texsources;

import com.mojang.blaze3d.platform.NativeImage;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.lukebemish.dynamicassetgenerator.api.ResourceGenerationContext;
import dev.lukebemish.dynamicassetgenerator.api.client.generators.TexSource;
import dev.lukebemish.dynamicassetgenerator.api.client.generators.TexSourceDataHolder;
import dev.lukebemish.dynamicassetgenerator.api.client.image.ImageUtils;
import dev.lukebemish.dynamicassetgenerator.api.colors.Channel;
import dev.lukebemish.dynamicassetgenerator.api.colors.ColorTypes;
import dev.lukebemish.dynamicassetgenerator.api.colors.operations.PointwiseOperation;
import dev.lukebemish.dynamicassetgenerator.impl.util.MultiCloser;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.server.packs.resources.IoSupplier;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

public class ChannelRouteSource
implements TexSource {
    public static final MapCodec<ChannelRouteSource> CODEC = RecordCodecBuilder.mapCodec(i -> i.group((App)Codec.unboundedMap((Codec)Codec.STRING, TexSource.CODEC).fieldOf("sources").forGetter(ChannelRouteSource::getSources), (App)ChannelSource.CODEC.optionalFieldOf("red").forGetter(s -> Optional.ofNullable(s.getRed())), (App)ChannelSource.CODEC.optionalFieldOf("green").forGetter(s -> Optional.ofNullable(s.getGreen())), (App)ChannelSource.CODEC.optionalFieldOf("blue").forGetter(s -> Optional.ofNullable(s.getBlue())), (App)ChannelSource.CODEC.optionalFieldOf("alpha").forGetter(s -> Optional.ofNullable(s.getAlpha()))).apply((Applicative)i, (sources, red, green, blue, alpha) -> new ChannelRouteSource((Map<String, TexSource>)sources, red.orElse(null), green.orElse(null), blue.orElse(null), alpha.orElse(null))));
    private final Map<String, TexSource> sources;
    private final @Nullable ChannelSource red;
    private final @Nullable ChannelSource green;
    private final @Nullable ChannelSource blue;
    private final @Nullable ChannelSource alpha;

    private ChannelRouteSource(Map<String, TexSource> sources, @Nullable ChannelSource red, @Nullable ChannelSource green, @Nullable ChannelSource blue, @Nullable ChannelSource alpha) {
        this.sources = sources;
        this.red = red;
        this.green = green;
        this.blue = blue;
        this.alpha = alpha;
    }

    public Map<String, TexSource> getSources() {
        return this.sources;
    }

    public @Nullable ChannelSource getRed() {
        return this.red;
    }

    public @Nullable ChannelSource getGreen() {
        return this.green;
    }

    public @Nullable ChannelSource getBlue() {
        return this.blue;
    }

    @Override
    public @NonNull MapCodec<? extends TexSource> codec() {
        return CODEC;
    }

    @Override
    public @Nullable IoSupplier<NativeImage> getSupplier(TexSourceDataHolder data, ResourceGenerationContext context) {
        HashMap<String, IoSupplier<NativeImage>> inputs = new HashMap<String, IoSupplier<NativeImage>>();
        for (Map.Entry<String, TexSource> entry : this.sources.entrySet()) {
            IoSupplier<NativeImage> input = entry.getValue().getCachedSupplier(data, context);
            if (input == null) {
                data.getLogger().error("Texture given was nonexistent...\n{}", (Object)entry.getValue().stringify());
                return null;
            }
            inputs.put(entry.getKey(), input);
        }
        if (this.red != null && !inputs.containsKey(this.red.getSource())) {
            data.getLogger().error("Red channel source given was nonexistent: {}", (Object)this.red.getSource());
            return null;
        }
        if (this.green != null && !inputs.containsKey(this.green.getSource())) {
            data.getLogger().error("Green channel source given was nonexistent: {}", (Object)this.green.getSource());
            return null;
        }
        if (this.blue != null && !inputs.containsKey(this.blue.getSource())) {
            data.getLogger().error("Blue channel source given was nonexistent: {}", (Object)this.blue.getSource());
            return null;
        }
        if (this.alpha != null && !inputs.containsKey(this.alpha.getSource())) {
            data.getLogger().error("Alpha channel source given was nonexistent: {}", (Object)this.alpha.getSource());
            return null;
        }
        return () -> {
            PointwiseOperation.Unary<Integer> rOperation = this.red == null ? null : this.red.getChannel().makeOperation();
            PointwiseOperation.Unary<Integer> gOperation = this.green == null ? null : this.green.getChannel().makeOperation();
            PointwiseOperation.Unary<Integer> bOperation = this.blue == null ? null : this.blue.getChannel().makeOperation();
            PointwiseOperation.Unary<Integer> aOperation = this.alpha == null ? null : this.alpha.getChannel().makeOperation();
            int running = 0;
            int aIdx = this.alpha != null ? running++ : -1;
            int rIdx = this.red != null ? running++ : -1;
            int gIdx = this.green != null ? running++ : -1;
            int bIdx = this.blue != null ? running : -1;
            PointwiseOperation.Any operation = (cs, is) -> {
                int aNew = aIdx == -1 ? 255 : (Integer)aOperation.apply(cs[aIdx], is[aIdx]);
                int rNew = rIdx == -1 ? 0 : (Integer)rOperation.apply(cs[rIdx], is[rIdx]);
                int gNew = gIdx == -1 ? 0 : (Integer)gOperation.apply(cs[gIdx], is[gIdx]);
                int bNew = bIdx == -1 ? 0 : (Integer)bOperation.apply(cs[bIdx], is[bIdx]);
                return ColorTypes.ARGB32.color(aNew, rNew, gNew, bNew);
            };
            NativeImage aImg = this.alpha == null ? null : (NativeImage)((IoSupplier)inputs.get(this.alpha.getSource())).get();
            NativeImage rImg = this.red == null ? null : (NativeImage)((IoSupplier)inputs.get(this.red.getSource())).get();
            NativeImage gImg = this.green == null ? null : (NativeImage)((IoSupplier)inputs.get(this.green.getSource())).get();
            NativeImage bImg = this.blue == null ? null : (NativeImage)((IoSupplier)inputs.get(this.blue.getSource())).get();
            ArrayList<NativeImage> images = new ArrayList<NativeImage>();
            if (aImg != null) {
                images.add(aImg);
            }
            if (rImg != null) {
                images.add(rImg);
            }
            if (gImg != null) {
                images.add(gImg);
            }
            if (bImg != null) {
                images.add(bImg);
            }
            try (MultiCloser ignored = new MultiCloser(images);){
                NativeImage nativeImage = ImageUtils.generateScaledImage(operation, images);
                return nativeImage;
            }
        };
    }

    public @Nullable ChannelSource getAlpha() {
        return this.alpha;
    }

    public static class ChannelSource {
        public static final Codec<ChannelSource> CODEC = RecordCodecBuilder.create(i -> i.group((App)Codec.STRING.fieldOf("source").forGetter(ChannelSource::getSource), (App)Channel.CODEC.fieldOf("channel").forGetter(ChannelSource::getChannel)).apply((Applicative)i, ChannelSource::new));
        private final String source;
        private final Channel channel;

        private ChannelSource(String source, Channel channel) {
            this.source = source;
            this.channel = channel;
        }

        public Channel getChannel() {
            return this.channel;
        }

        public String getSource() {
            return this.source;
        }

        public static class Builder {
            private String source;
            private Channel channel;

            public Builder setSource(String source) {
                this.source = source;
                return this;
            }

            public Builder setChannel(Channel channel) {
                this.channel = channel;
                return this;
            }

            public ChannelSource build() {
                Objects.requireNonNull(this.source);
                Objects.requireNonNull(this.channel);
                return new ChannelSource(this.source, this.channel);
            }
        }
    }

    public static class Builder {
        private Map<String, TexSource> sources;
        private @Nullable ChannelSource red;
        private @Nullable ChannelSource green;
        private @Nullable ChannelSource blue;
        private @Nullable ChannelSource alpha;

        public Builder setSources(Map<String, TexSource> sources) {
            this.sources = sources;
            return this;
        }

        public Builder setRed(@Nullable ChannelSource red) {
            this.red = red;
            return this;
        }

        public Builder setGreen(@Nullable ChannelSource green) {
            this.green = green;
            return this;
        }

        public Builder setBlue(@Nullable ChannelSource blue) {
            this.blue = blue;
            return this;
        }

        public Builder setAlpha(@Nullable ChannelSource alpha) {
            this.alpha = alpha;
            return this;
        }

        public ChannelRouteSource build() {
            Objects.requireNonNull(this.sources);
            return new ChannelRouteSource(this.sources, this.red, this.green, this.blue, this.alpha);
        }
    }
}

