/*
 * Decompiled with CFR 0.152.
 */
package dev.lukebemish.dynamicassetgenerator.api.client.generators;

import com.google.gson.JsonElement;
import com.mojang.blaze3d.platform.NativeImage;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.MapCodec;
import dev.lukebemish.dynamicassetgenerator.api.ResourceGenerationContext;
import dev.lukebemish.dynamicassetgenerator.api.cache.CacheMetaCodec;
import dev.lukebemish.dynamicassetgenerator.api.cache.DataConsumer;
import dev.lukebemish.dynamicassetgenerator.api.client.generators.TexSourceDataHolder;
import dev.lukebemish.dynamicassetgenerator.impl.DynamicAssetGenerator;
import dev.lukebemish.dynamicassetgenerator.impl.ResourceCachingData;
import dev.lukebemish.dynamicassetgenerator.impl.client.ClientRegisters;
import dev.lukebemish.dynamicassetgenerator.impl.client.TexSourceCache;
import java.util.List;
import java.util.function.Function;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.IoSupplier;
import org.jetbrains.annotations.ApiStatus;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

public interface TexSource {
    @ApiStatus.Internal
    public static final String METADATA_CACHE_KEY = "__dynamic_asset_generator_metadata";
    public static final Codec<TexSource> CODEC = CacheMetaCodec.of(Codec.lazyInitialized(() -> new Codec<MapCodec<? extends TexSource>>(){

        public <T> DataResult<Pair<MapCodec<? extends TexSource>, T>> decode(DynamicOps<T> ops, T input) {
            return ResourceLocation.CODEC.decode(ops, input).flatMap(keyValuePair -> !ClientRegisters.TEXSOURCES.containsKey(keyValuePair.getFirst()) ? DataResult.error(() -> "Unknown dynamic texture source type: " + String.valueOf(keyValuePair.getFirst())) : DataResult.success((Object)keyValuePair.mapFirst(arg_0 -> ClientRegisters.TEXSOURCES.get(arg_0))));
        }

        public <T> DataResult<T> encode(MapCodec<? extends TexSource> input, DynamicOps<T> ops, T prefix) {
            ResourceLocation key = (ResourceLocation)ClientRegisters.TEXSOURCES.inverse().get(input);
            if (key == null) {
                return DataResult.error(() -> "Unregistered dynamic texture source type: " + String.valueOf(input));
            }
            Object toMerge = ops.createString(key.toString());
            return ops.mergeToPrimitive(prefix, toMerge);
        }
    }).dispatch(TexSource::codec, Function.identity()), List.of(CacheMetaCodec.SingleCacheType.of(new DataConsumer<TexSourceDataHolder, TexSource>(){

        @Override
        public <T1> @NonNull DataResult<T1> encode(DynamicOps<T1> ops, TexSourceDataHolder data, TexSource object) {
            return object.cacheMetadata(ops, data);
        }
    }, "__dynamic_asset_generator_metadata", TexSourceDataHolder.class), CacheMetaCodec.SingleCacheType.of(new DataConsumer<ResourceCachingData, TexSource>(){

        @Override
        public <T1> @NonNull DataResult<T1> encode(DynamicOps<T1> ops, ResourceCachingData data, TexSource object) {
            return object.persistentCacheData(ops, data.context());
        }
    }, "__dynamic_asset_generator_persistent", ResourceCachingData.class)));

    public static <T extends TexSource> void register(ResourceLocation rl, MapCodec<T> codec) {
        ClientRegisters.TEXSOURCES.put((Object)rl, codec);
    }

    @ApiStatus.Experimental
    default public <T> @NonNull DataResult<T> cacheMetadata(DynamicOps<T> ops, TexSourceDataHolder data) {
        return DataResult.success((Object)ops.empty());
    }

    @ApiStatus.Experimental
    default public <T> @NonNull DataResult<T> persistentCacheData(DynamicOps<T> ops, ResourceGenerationContext context) {
        return DataResult.success((Object)ops.empty());
    }

    public @NonNull MapCodec<? extends TexSource> codec();

    @ApiStatus.OverrideOnly
    public @Nullable IoSupplier<NativeImage> getSupplier(TexSourceDataHolder var1, ResourceGenerationContext var2);

    @ApiStatus.NonExtendable
    default public @Nullable IoSupplier<NativeImage> getCachedSupplier(TexSourceDataHolder data, ResourceGenerationContext context) {
        IoSupplier<NativeImage> wrapperImage = this.getSupplier(data, context);
        if (wrapperImage == null) {
            return null;
        }
        return () -> TexSourceCache.fromCache(wrapperImage, this, context, data);
    }

    default public String stringify() {
        JsonElement element = CODEC.encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)this).result().orElse(null);
        if (element == null) {
            return this.toString();
        }
        return DynamicAssetGenerator.GSON_FLAT.toJson(element);
    }
}

