/*
 * Decompiled with CFR 0.152.
 */
package dev.lukebemish.dynamicassetgenerator.impl.fabriquilt.quilt;

import dev.lukebemish.dynamicassetgenerator.impl.DynamicAssetGenerator;
import dev.lukebemish.dynamicassetgenerator.impl.fabriquilt.fabric.FabricPlatform;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.util.List;
import java.util.stream.Stream;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_3262;
import org.jspecify.annotations.Nullable;

public class QuiltPlatformMinimal
extends FabricPlatform {
    public static final QuiltPlatformMinimal INSTANCE;
    private static final boolean isQFAPIPresent;
    private static final String GROUP_PACK_CLASS = "org.quiltmc.qsl.resource.loader.api.GroupResourcePack";
    private static final @Nullable Class<?> GROUP_PACK_RESOURCES;
    private static final @Nullable MethodHandle GET_GROUP_PACK_PACKS;
    private static final boolean[] LOGGED_ERROR;

    private synchronized void logError(int i) {
        if (!LOGGED_ERROR[i]) {
            if (i == 0) {
                DynamicAssetGenerator.LOGGER.error("Found quilt delegating resources but could not properly use quilt class/field to unwrap grouped resources - Dynamic Asset Generator may not work right!");
            }
            QuiltPlatformMinimal.LOGGED_ERROR[i] = true;
        }
    }

    @Override
    public Stream<class_3262> unpackPacks(Stream<? extends class_3262> packs) {
        return packs.flatMap(pack -> {
            if (GROUP_PACK_RESOURCES != null && GET_GROUP_PACK_PACKS != null && GROUP_PACK_RESOURCES.isInstance(pack)) {
                try {
                    List unpackedPacks = GET_GROUP_PACK_PACKS.invoke((class_3262)pack);
                    return Stream.concat(Stream.of(pack), this.unpackPacks(unpackedPacks.stream()));
                }
                catch (Throwable e) {
                    this.logError(0);
                }
            }
            return super.unpackPacks(Stream.of(pack));
        });
    }

    static {
        Class<?> clazz;
        INSTANCE = new QuiltPlatformMinimal();
        isQFAPIPresent = FabricLoader.getInstance().isModLoaded("quilted_fabric_api");
        try {
            clazz = FabricPlatform.class.getClassLoader().loadClass(GROUP_PACK_CLASS);
        }
        catch (ClassNotFoundException e) {
            clazz = null;
        }
        if (clazz == null) {
            GROUP_PACK_RESOURCES = null;
            GET_GROUP_PACK_PACKS = null;
        } else {
            MethodHandle getter;
            GROUP_PACK_RESOURCES = clazz;
            MethodHandles.Lookup lookup = MethodHandles.lookup();
            try {
                MethodHandles.Lookup privateLookup = MethodHandles.privateLookupIn(clazz, lookup);
                Class<List> listClazz = List.class;
                getter = privateLookup.findVirtual(clazz, "getPacks", MethodType.methodType(listClazz));
            }
            catch (IllegalAccessException | NoSuchMethodException e) {
                getter = null;
            }
            GET_GROUP_PACK_PACKS = getter;
        }
        if (GROUP_PACK_RESOURCES == null || GET_GROUP_PACK_PACKS == null && isQFAPIPresent) {
            DynamicAssetGenerator.LOGGER.error("On quilt but could not find quilt class/field to unwrap grouped resources - Dynamic Asset Generator may not work right!");
        }
        LOGGED_ERROR = new boolean[1];
    }
}

