/*
 * Decompiled with CFR 0.152.
 */
package dev.lukebemish.dynamicassetgenerator.impl.client;

import com.google.gson.Gson;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.DynamicOps;
import dev.lukebemish.dynamicassetgenerator.api.ResourceGenerationContext;
import dev.lukebemish.dynamicassetgenerator.api.cache.CacheMetaJsonOps;
import dev.lukebemish.dynamicassetgenerator.api.client.generators.TexSource;
import dev.lukebemish.dynamicassetgenerator.api.client.generators.TexSourceDataHolder;
import dev.lukebemish.dynamicassetgenerator.impl.CacheReference;
import dev.lukebemish.dynamicassetgenerator.impl.DynamicAssetGenerator;
import dev.lukebemish.dynamicassetgenerator.impl.client.NativeImageHelper;
import java.io.IOException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.class_1011;
import net.minecraft.class_2960;
import net.minecraft.class_7367;
import org.jspecify.annotations.NonNull;

public final class TexSourceCache {
    private static final Map<class_2960, Map<String, CacheReference<Either<class_1011, IOException>>>> MULTI_CACHE = new ConcurrentHashMap<class_2960, Map<String, CacheReference<Either<class_1011, IOException>>>>();

    private TexSourceCache() {
    }

    public static @NonNull class_1011 fromCache(class_7367<class_1011> supplier, TexSource source, ResourceGenerationContext context, TexSourceDataHolder data) throws IOException {
        Map cache = MULTI_CACHE.computeIfAbsent(context.getCacheName(), k -> new ConcurrentHashMap());
        try {
            CacheMetaJsonOps dataOps = new CacheMetaJsonOps();
            dataOps.putData(TexSourceDataHolder.class, data);
            String cacheKey = TexSource.CODEC.encodeStart((DynamicOps)dataOps, (Object)source).result().map(arg_0 -> ((Gson)DynamicAssetGenerator.GSON_FLAT).toJson(arg_0)).orElse(null);
            if (cacheKey == null) {
                return (class_1011)supplier.get();
            }
            CacheReference ref = cache.containsKey(cacheKey) ? (CacheReference)cache.get(cacheKey) : new CacheReference();
            Either result = ref.calcSync(cached -> {
                if (cached == null) {
                    try {
                        class_1011 image = (class_1011)supplier.get();
                        ref.setHeld(Either.left((Object)image));
                        class_1011 output = NativeImageHelper.of(image.method_4318(), image.method_4307(), image.method_4323(), false);
                        output.method_4317(image);
                        return Either.left((Object)output);
                    }
                    catch (IOException e) {
                        ref.setHeld(Either.right((Object)e));
                        return Either.right((Object)e);
                    }
                }
                if (cached.left().isPresent()) {
                    class_1011 image = (class_1011)cached.left().get();
                    class_1011 output = NativeImageHelper.of(image.method_4318(), image.method_4307(), image.method_4323(), false);
                    output.method_4317(image);
                    return Either.left((Object)output);
                }
                return Either.right((Object)((IOException)cached.right().get()));
            });
            if (!cache.containsKey(cacheKey)) {
                cache.put(cacheKey, ref);
            }
            if (result.left().isPresent()) {
                return (class_1011)result.left().get();
            }
            throw (IOException)result.right().get();
        }
        catch (RuntimeException e) {
            DynamicAssetGenerator.LOGGER.warn("Could not cache texture source; something has gone wrong with encoding or texture creation.", (Throwable)e);
            return (class_1011)supplier.get();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void reset(ResourceGenerationContext context) {
        Map<class_2960, Map<String, CacheReference<Either<class_1011, IOException>>>> map = MULTI_CACHE;
        synchronized (map) {
            Map<String, CacheReference<Either<class_1011, IOException>>> cache = MULTI_CACHE.get(context.getCacheName());
            if (cache != null) {
                cache.forEach((s, e) -> {
                    if (((Either)e.getHeld()).left().isPresent()) {
                        ((class_1011)((Either)e.getHeld()).left().get()).close();
                    }
                });
                MULTI_CACHE.remove(context.getCacheName());
            }
        }
    }
}

