/*
 * Decompiled with CFR 0.152.
 */
package dev.lukebemish.dynamicassetgenerator.impl.client;

import com.mojang.serialization.DataResult;
import dev.lukebemish.dynamicassetgenerator.api.ResourceGenerationContext;
import dev.lukebemish.dynamicassetgenerator.api.client.image.ImageUtils;
import dev.lukebemish.dynamicassetgenerator.api.colors.ColorTypes;
import dev.lukebemish.dynamicassetgenerator.api.colors.Palette;
import dev.lukebemish.dynamicassetgenerator.api.colors.clustering.Cluster;
import dev.lukebemish.dynamicassetgenerator.api.colors.clustering.Clusterer;
import dev.lukebemish.dynamicassetgenerator.api.colors.geometry.ColorCoordinates;
import dev.lukebemish.dynamicassetgenerator.impl.CacheReference;
import dev.lukebemish.dynamicassetgenerator.impl.DynamicAssetGenerator;
import dev.lukebemish.dynamicassetgenerator.impl.client.NativeImageHelper;
import it.unimi.dsi.fastutil.longs.Long2IntOpenHashMap;
import java.io.Closeable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Predicate;
import java.util.stream.IntStream;
import net.minecraft.class_1011;
import net.minecraft.class_2960;
import net.minecraft.class_5253;
import org.jspecify.annotations.Nullable;

public class ForegroundExtractor
implements Closeable {
    private static final int[] X_SAMPLING_ORDER = new int[]{-1, -1, -1, 0, 0, 0, 1, 1, 1};
    private static final int[] Y_SAMPLING_ORDER = new int[]{-1, 0, 1, -1, 0, 1, -1, 0, 1};
    private static final int[] ALPHAS = new int[]{26, 38, 51, 64};
    private static final Map<class_2960, Map<String, CacheReference<OutputHolder>>> MULTI_CACHE = new ConcurrentHashMap<class_2960, Map<String, CacheReference<OutputHolder>>>();
    private boolean fillHoles = false;
    private final boolean[] hasLogged = new boolean[3];
    private final double closeCutoff;
    private final class_1011 background;
    private final class_1011 withOverlay;
    public final Predicate<Palette> extend;
    public final boolean trimTrailingPaletteLookup;
    private final boolean forceOverlayNeighbors;
    private final class_2960 cacheName;
    private final DataResult<String> cacheKey;
    private OutputHolder outputHolder;
    private final ColorTypes.ConversionCache32 rgb2labCache = new ColorTypes.ConversionCache32(ColorTypes.CIELAB32::fromARGB32);
    private final ColorCoordinates coordinatesLab = new ColorCoordinates(){

        @Override
        public int getX(int color) {
            return ColorTypes.CIELAB32.lightness(ForegroundExtractor.this.rgb2labCache.convert(color));
        }

        @Override
        public int getY(int color) {
            return ColorTypes.CIELAB32.a(ForegroundExtractor.this.rgb2labCache.convert(color));
        }

        @Override
        public int getZ(int color) {
            return ColorTypes.CIELAB32.b(ForegroundExtractor.this.rgb2labCache.convert(color));
        }
    };
    private static final int[] TO_SEARCH_XS = new int[]{0, 1, 0, -1};
    private static final int[] TO_SEARCH_YS = new int[]{1, 0, -1, 0};

    public ForegroundExtractor(class_2960 cacheName, DataResult<String> cacheKey, class_1011 background, class_1011 withOverlay, Predicate<Palette> extend, boolean trimTrailingPaletteLookup, boolean forceOverlayNeighbors, double closeCutoff) {
        this.cacheName = cacheName;
        this.cacheKey = cacheKey;
        this.background = background;
        this.withOverlay = withOverlay;
        this.extend = extend;
        this.trimTrailingPaletteLookup = trimTrailingPaletteLookup;
        this.forceOverlayNeighbors = forceOverlayNeighbors;
        this.closeCutoff = closeCutoff;
    }

    public class_1011 getOverlayImg() {
        return this.outputHolder.o;
    }

    public class_1011 getPalettedImg() {
        return this.outputHolder.p;
    }

    private void tryCloseOutputs() {
        if (this.outputHolder != null) {
            this.outputHolder.close();
            this.outputHolder = null;
        }
    }

    private Holder recalcImagesAlternate() {
        int bDim = Math.min(this.background.method_4323(), this.background.method_4307());
        int wDim = Math.min(this.withOverlay.method_4323(), this.withOverlay.method_4307());
        int dim = Math.max(bDim, wDim);
        int bs = dim / bDim;
        int ws = dim / wDim;
        class_1011 oImg = NativeImageHelper.of(class_1011.class_1012.field_4997, dim, dim, false);
        class_1011 pImg = NativeImageHelper.of(class_1011.class_1012.field_4997, dim, dim, false);
        Palette backgroundPalette = ImageUtils.getPalette(this.background);
        backgroundPalette.extend(this.extend);
        Palette withOverlayPalette = ImageUtils.getPalette(this.withOverlay);
        Clusterer clusterer = new Clusterer(Clusterer.minimumSpacing(backgroundPalette));
        clusterer.addCluster(new Cluster(backgroundPalette));
        Palette notBackgroundPalette = new Palette();
        for (int color : withOverlayPalette) {
            if (backgroundPalette.contains(color)) continue;
            clusterer.addCluster(new Cluster(color));
            notBackgroundPalette.add(color);
        }
        clusterer.run();
        Palette fColors = new Palette();
        int bgCat = clusterer.getCategory(backgroundPalette.getColor(0));
        for (int color : notBackgroundPalette) {
            if (clusterer.getCategory(color) == bgCat) continue;
            fColors.add(color);
        }
        if (fColors.isEmpty()) {
            for (int x2 = 0; x2 < dim; ++x2) {
                for (int y = 0; y < dim; ++y) {
                    ImageUtils.safeSetPixelABGR(oImg, x2, y, 0);
                    int bC = ImageUtils.safeGetPixelARGB(this.background, x2 / bs, y / bs);
                    int wC = ImageUtils.safeGetPixelARGB(this.withOverlay, x2 / ws, y / ws);
                    int bSample = backgroundPalette.getSample(bC);
                    int wSample = backgroundPalette.getSample(wC);
                    if (wSample != bSample) {
                        ImageUtils.safeSetPixelABGR(pImg, x2, y, class_5253.class_8045.method_48344((int)255, (int)wSample, (int)wSample, (int)wSample));
                        continue;
                    }
                    ImageUtils.safeSetPixelABGR(pImg, x2, y, 0);
                }
            }
            if (!this.hasLogged[0]) {
                DynamicAssetGenerator.LOGGER.warn("Supplied images for extraction contained no differing colors; only extracting palette shifts");
            }
            this.hasLogged[0] = true;
            return new Holder(oImg, pImg);
        }
        IntStream.range(0, dim).parallel().forEach(x -> {
            for (int y = 0; y < dim; ++y) {
                int bSample;
                int bC = ImageUtils.safeGetPixelARGB(this.background, x / bs, y / bs);
                int wC = ImageUtils.safeGetPixelARGB(this.withOverlay, x / ws, y / ws);
                if (fColors.contains(wC)) {
                    ImageUtils.safeSetPixelARGB(oImg, x, y, wC | 0xFF000000);
                    continue;
                }
                if (backgroundPalette.contains(wC)) {
                    int wSample = backgroundPalette.getSample(wC);
                    if (wSample == (bSample = backgroundPalette.getSample(bC))) continue;
                    ImageUtils.safeGetPixelABGR(oImg, x, y, class_5253.class_8045.method_48344((int)255, (int)wSample, (int)wSample, (int)wSample));
                    continue;
                }
                int fIndex = 0;
                bSample = 0;
                double lowest = 65025.0;
                int alpha = 0;
                boolean skipOverlay = false;
                for (int a : ALPHAS) {
                    for (int b = 0; b < backgroundPalette.size(); ++b) {
                        double dist;
                        int fWithAlpha;
                        int fColor;
                        int bColor;
                        for (int f = 0; f < fColors.size(); ++f) {
                            bColor = backgroundPalette.getColorFromIndex(b);
                            fColor = fColors.getColorFromIndex(f);
                            fWithAlpha = fColor & 0xFFFFFF | a << 24;
                            dist = this.extractorDistance(ColorTypes.ARGB32.alphaBlend(fWithAlpha, bColor), wC);
                            if (!(dist < lowest)) continue;
                            lowest = dist;
                            alpha = a;
                            fIndex = f;
                            bSample = b * 256 / backgroundPalette.size();
                            skipOverlay = false;
                        }
                        for (int b1 = 0; b1 < backgroundPalette.size(); ++b1) {
                            bColor = backgroundPalette.getColorFromIndex(b);
                            fColor = backgroundPalette.getColorFromIndex(b1);
                            fWithAlpha = fColor & 0xFFFFFF | a << 24;
                            dist = this.extractorDistance(ColorTypes.ARGB32.alphaBlend(fWithAlpha, bColor), wC);
                            if (!(dist < lowest)) continue;
                            lowest = dist;
                            alpha = a;
                            bSample = backgroundPalette.getSample(fWithAlpha);
                            skipOverlay = true;
                        }
                    }
                }
                for (int f = 0; f < fColors.size(); ++f) {
                    int fColor = fColors.getColorFromIndex(f);
                    double dist = this.extractorDistance(fColor, wC);
                    if (!(dist < lowest)) continue;
                    lowest = dist;
                    alpha = 255;
                    fIndex = f;
                    skipOverlay = false;
                }
                ImageUtils.safeSetPixelARGB(pImg, x, y, bSample);
                if (!skipOverlay) {
                    ImageUtils.safeSetPixelARGB(oImg, x, y, fColors.getColorFromIndex(fIndex) & 0xFFFFFF | alpha << 24);
                }
                if (alpha < 255) continue;
                ImageUtils.safeSetPixelABGR(oImg, x, y, 0);
            }
        });
        this.trimAndOverlay(dim, ws, oImg, pImg, this.withOverlay, backgroundPalette);
        return new Holder(oImg, pImg);
    }

    private void trimAndOverlay(int dim, int ws, class_1011 oImg, class_1011 pImg, class_1011 wImg, Palette backgroundPalette) {
        if (this.trimTrailingPaletteLookup || this.forceOverlayNeighbors) {
            IntStream.range(0, dim).parallel().forEach(x -> {
                for (int y = 0; y < dim; ++y) {
                    boolean hasNeighbor = false;
                    boolean hasFullNeighbor = false;
                    for (int j = 0; j < X_SAMPLING_ORDER.length; ++j) {
                        int xt = x + X_SAMPLING_ORDER[j];
                        int yt = y + Y_SAMPLING_ORDER[j];
                        if (0 > xt || xt >= dim || 0 > yt || yt >= dim) continue;
                        int alpha = class_5253.class_8045.method_48342((int)ImageUtils.safeGetPixelABGR(oImg, xt, yt));
                        if (alpha != 0) {
                            hasNeighbor = true;
                        }
                        if (alpha < 255) continue;
                        hasFullNeighbor = true;
                    }
                    if (this.trimTrailingPaletteLookup && !hasNeighbor) {
                        ImageUtils.safeSetPixelABGR(pImg, x, y, 0);
                    }
                    if (!this.forceOverlayNeighbors || !hasFullNeighbor || class_5253.class_8045.method_48342((int)ImageUtils.safeGetPixelABGR(oImg, x, y)) != 0) continue;
                    int wColor = ImageUtils.safeGetPixelARGB(wImg, x / ws, y / ws);
                    int wSample = backgroundPalette.getSample(wColor);
                    ImageUtils.safeSetPixelABGR(pImg, x, y, class_5253.class_8045.method_48344((int)255, (int)wSample, (int)wSample, (int)wSample));
                }
            });
        }
    }

    private void recalcImages() {
        int bDim = Math.min(this.background.method_4323(), this.background.method_4307());
        int wDim = Math.min(this.withOverlay.method_4323(), this.withOverlay.method_4307());
        int dim = Math.max(bDim, wDim);
        int bs = dim / bDim;
        int ws = dim / wDim;
        class_1011 oImg = NativeImageHelper.of(class_1011.class_1012.field_4997, dim, dim, false);
        class_1011 pImg = NativeImageHelper.of(class_1011.class_1012.field_4997, dim, dim, false);
        Palette backgroundPalette = ImageUtils.getPalette(this.background);
        backgroundPalette.extend(this.extend);
        Palette withOverlayPalette = ImageUtils.getPalette(this.withOverlay);
        withOverlayPalette.extend(this.extend);
        double workingAvgDiff = 0.0;
        int avgCount = 0;
        for (int c1 : backgroundPalette) {
            for (int c2 : backgroundPalette) {
                workingAvgDiff += this.extractorDistance(c1, c2);
                ++avgCount;
            }
        }
        if (avgCount > 0) {
            workingAvgDiff /= (double)avgCount;
        }
        double avgDiff = workingAvgDiff;
        Palette frontColors = new Palette();
        ArrayList<PostCalcEvent> postQueue = new ArrayList<PostCalcEvent>();
        IntStream.range(0, dim).parallel().forEach(x -> {
            for (int y = 0; y < dim; ++y) {
                int bColor = ImageUtils.safeGetPixelARGB(this.background, x / bs, y / bs);
                int wColor = ImageUtils.safeGetPixelARGB(this.withOverlay, x / ws, y / ws);
                if (backgroundPalette.contains(wColor)) {
                    int bSample;
                    int wSample = backgroundPalette.getSample(wColor);
                    if (wSample == (bSample = backgroundPalette.getSample(bColor))) continue;
                    ImageUtils.safeSetPixelABGR(pImg, x, y, class_5253.class_8045.method_48344((int)255, (int)wSample, (int)wSample, (int)wSample));
                    continue;
                }
                int closestSample = backgroundPalette.getSample(wColor);
                if (backgroundPalette.distanceToPolyLine(wColor, this.coordinatesLab) < this.closeCutoff * avgDiff) {
                    ImageUtils.safeSetPixelABGR(pImg, x, y, class_5253.class_8045.method_48344((int)255, (int)closestSample, (int)closestSample, (int)closestSample));
                    ArrayList arrayList = postQueue;
                    synchronized (arrayList) {
                        postQueue.add(new PostCalcEvent(x, y, wColor));
                        continue;
                    }
                }
                ImageUtils.safeSetPixelARGB(oImg, x, y, wColor);
                Palette palette = frontColors;
                synchronized (palette) {
                    frontColors.add(wColor);
                    continue;
                }
            }
        });
        if (frontColors.isEmpty() || frontColors.size() * backgroundPalette.size() * postQueue.size() > DynamicAssetGenerator.getConfig().paletteForceClusteringCutoff()) {
            Holder alt = this.recalcImagesAlternate();
            if (frontColors.isEmpty()) {
                if (!this.hasLogged[1]) {
                    DynamicAssetGenerator.LOGGER.warn("Supplied images for extraction contained few differing colors; attempting clustering color extraction.");
                }
                this.hasLogged[1] = true;
            } else {
                if (!this.hasLogged[2]) {
                    DynamicAssetGenerator.LOGGER.warn("Supplied images for extraction contained too many colors and were too high resolution to resolve post-calculation queue; attempting clustering color extraction.");
                }
                this.hasLogged[2] = true;
            }
            this.outputHolder = new OutputHolder(alt.o(), alt.p());
            oImg.close();
            pImg.close();
            return;
        }
        this.runPostCalcQueue(oImg, pImg, backgroundPalette, frontColors, postQueue);
        this.trimAndOverlay(dim, ws, oImg, pImg, this.withOverlay, backgroundPalette);
        if ((this.trimTrailingPaletteLookup || this.forceOverlayNeighbors) && this.fillHoles) {
            int overlay;
            int y;
            int x2;
            int s = pImg.method_4307();
            Long2IntOpenHashMap alphaMap = new Long2IntOpenHashMap();
            for (x2 = 0; x2 < s; ++x2) {
                for (y = 0; y < s; ++y) {
                    overlay = ImageUtils.safeGetPixelABGR(oImg, x2, y);
                    int alpha = class_5253.class_8045.method_48342((int)overlay);
                    alphaMap.put(ForegroundExtractor.pair(x2, y), alpha);
                    int wOverlayColor = ImageUtils.safeGetPixelABGR(this.withOverlay, x2 / ws, y / ws);
                    if (alpha != 255 || wOverlayColor == overlay) continue;
                    ImageUtils.safeSetPixelABGR(oImg, x2, y, wOverlayColor | 0xFF000000);
                }
            }
            while (true) {
                block5: for (x2 = 1; x2 < s - 1; ++x2) {
                    for (y = 1; y < s - 1; ++y) {
                        overlay = ImageUtils.safeGetPixelARGB(oImg, x2, y);
                        int count = 0;
                        int partialCount = 0;
                        for (int idx = 0; idx < TO_SEARCH_XS.length; ++idx) {
                            int xOff = TO_SEARCH_XS[idx];
                            int yOff = TO_SEARCH_YS[idx];
                            int c = ImageUtils.safeGetPixelARGB(oImg, x2 + xOff, y + yOff);
                            int alpha = class_5253.class_5254.method_27762((int)c);
                            if (alpha == 255) {
                                ++count;
                            }
                            if (alpha <= 0 || alphaMap.get(ForegroundExtractor.pair(x2 + xOff, y + yOff)) >= 255) continue;
                            ++partialCount;
                        }
                        int origC = ImageUtils.safeGetPixelARGB(this.withOverlay, x2 / ws, y / ws);
                        if (class_5253.class_5254.method_27762((int)overlay) == 255 || count < 3 && partialCount < 4 || backgroundPalette.contains(origC)) continue;
                        int orig = ImageUtils.safeGetPixelABGR(this.withOverlay, x2, y);
                        int i = 0;
                        while (true) {
                            if (i >= s) continue block5;
                            for (int j = 0; j < s; ++j) {
                                int c = ImageUtils.safeGetPixelABGR(this.withOverlay, i, j);
                                if (orig != c) continue;
                                ImageUtils.safeSetPixelARGB(oImg, i, j, origC | 0xFF000000);
                            }
                            ++i;
                        }
                    }
                }
                break;
            }
        }
        this.outputHolder = new OutputHolder(oImg, pImg);
    }

    private static long pair(int a, int b) {
        return (long)a << 32 | (long)b & 0xFFFFFFFFL;
    }

    private double extractorDistance(int color1, int color2) {
        int c1Lab = this.rgb2labCache.convert(color1);
        int c2Lab = this.rgb2labCache.convert(color2);
        return ColorTypes.CIELAB32.distance(c1Lab, c2Lab);
    }

    private void runPostCalcQueue(class_1011 oImg, class_1011 pImg, Palette backgroundPalette, Palette frontColors, List<PostCalcEvent> postQueue) {
        postQueue.parallelStream().forEach(e -> {
            int x = e.x();
            int y = e.y();
            int wColor = e.wColor();
            if (backgroundPalette.distanceToPolyLine(wColor, this.coordinatesLab) > frontColors.distanceToPolyLine(wColor, this.coordinatesLab)) {
                ImageUtils.safeSetPixelARGB(oImg, x, y, wColor | 0xFF000000);
                ImageUtils.safeSetPixelARGB(pImg, x, y, 0);
                return;
            }
            int fIndex = 0;
            int bSample = 0;
            double lowest = 65025.0;
            int alpha = 0;
            boolean skipOverlay = false;
            for (int a : ALPHAS) {
                for (int b = 0; b < backgroundPalette.size(); ++b) {
                    int fColor;
                    int bColor = backgroundPalette.getColorFromIndex(b);
                    for (int f = 0; f < frontColors.size(); ++f) {
                        fColor = frontColors.getColorFromIndex(f);
                        double dist = this.extractorDistance(wColor, ColorTypes.ARGB32.alphaBlend(fColor & 0xFFFFFF | a << 24, bColor));
                        if (!(dist < lowest)) continue;
                        lowest = dist;
                        alpha = a;
                        fIndex = f;
                        bSample = b * 256 / backgroundPalette.size();
                        skipOverlay = false;
                    }
                    for (int b1 = 0; b1 < backgroundPalette.size(); ++b1) {
                        fColor = backgroundPalette.getColorFromIndex(b1);
                        int blend = ColorTypes.ARGB32.alphaBlend(fColor & 0xFFFFFF | a << 24, bColor);
                        double dist = this.extractorDistance(wColor, blend);
                        if (!(dist < lowest)) continue;
                        lowest = dist;
                        alpha = a;
                        bSample = backgroundPalette.getSample(blend);
                        skipOverlay = true;
                    }
                }
            }
            for (int f = 0; f < frontColors.size(); ++f) {
                int fColor = frontColors.getColorFromIndex(f);
                double dist = this.extractorDistance(wColor, fColor);
                if (!(dist < lowest)) continue;
                lowest = dist;
                alpha = 255;
                fIndex = f;
                skipOverlay = false;
            }
            ImageUtils.safeSetPixelABGR(pImg, x, y, class_5253.class_8045.method_48344((int)255, (int)bSample, (int)bSample, (int)bSample));
            if (!skipOverlay) {
                int overlayColor = frontColors.getColorFromIndex(fIndex) & 0xFFFFFF | alpha << 24;
                ImageUtils.safeSetPixelARGB(oImg, x, y, overlayColor);
            }
            if (alpha == 255) {
                ImageUtils.safeSetPixelARGB(pImg, x, y, 0);
            }
        });
    }

    public ForegroundExtractor fillHoles(boolean fillHoles) {
        this.fillHoles = fillHoles;
        return this;
    }

    @Override
    public void close() {
        this.tryCloseOutputs();
        if (this.background != null) {
            this.background.close();
        }
        if (this.withOverlay != null) {
            this.withOverlay.close();
        }
    }

    public void unCacheOrReCalc() {
        if (this.cacheKey.result().isEmpty()) {
            this.recalcImages();
            return;
        }
        Map cache = MULTI_CACHE.computeIfAbsent(this.cacheName, k -> new ConcurrentHashMap());
        CacheReference ref = cache.computeIfAbsent((String)this.cacheKey.result().get(), k -> new CacheReference());
        ref.doSync(holder -> {
            if (holder != null) {
                this.outputHolder = holder.copy();
            } else {
                this.recalcImages();
                ref.setHeld(this.outputHolder.copy());
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void reset(ResourceGenerationContext context) {
        Map<class_2960, Map<String, CacheReference<OutputHolder>>> map = MULTI_CACHE;
        synchronized (map) {
            Map<String, CacheReference<OutputHolder>> cache = MULTI_CACHE.get(context.getCacheName());
            if (cache != null) {
                cache.forEach((s, e) -> ((OutputHolder)e.getHeld()).close());
                MULTI_CACHE.remove(context.getCacheName());
            }
        }
    }

    private record OutputHolder(@Nullable class_1011 o, @Nullable class_1011 p) implements Closeable
    {
        public OutputHolder copy() {
            class_1011 newO = null;
            if (this.o != null) {
                newO = NativeImageHelper.of(this.o.method_4318(), this.o.method_4307(), this.o.method_4323(), false);
                newO.method_4317(this.o);
            }
            class_1011 newP = null;
            if (this.p != null) {
                newP = NativeImageHelper.of(this.p.method_4318(), this.p.method_4307(), this.p.method_4323(), false);
                newP.method_4317(this.p);
            }
            return new OutputHolder(newO, newP);
        }

        @Override
        public void close() {
            if (this.p != null) {
                this.p.close();
            }
            if (this.o != null) {
                this.o.close();
            }
        }
    }

    private record Holder(class_1011 o, class_1011 p) implements Closeable
    {
        @Override
        public void close() {
            this.o.close();
            this.p.close();
        }
    }

    private record PostCalcEvent(int x, int y, int wColor) {
    }
}

