/*
 * Decompiled with CFR 0.152.
 */
package dev.lukebemish.dynamicassetgenerator.impl.client;

import com.google.gson.JsonElement;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.lukebemish.dynamicassetgenerator.api.ResourceGenerationContext;
import dev.lukebemish.dynamicassetgenerator.api.client.SpriteProvider;
import dev.lukebemish.dynamicassetgenerator.api.client.generators.TexSource;
import dev.lukebemish.dynamicassetgenerator.impl.DynamicAssetGenerator;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import net.minecraft.class_2960;
import net.minecraft.class_7654;
import org.jspecify.annotations.Nullable;

public record BuiltinSpriteProvider(Map<class_2960, TexSource> sources, @Nullable class_2960 location) implements SpriteProvider<BuiltinSpriteProvider>
{
    public static final class_2960 LOCATION = class_2960.method_60655((String)"dynamic_asset_generator", (String)"tex_sources");
    public static final MapCodec<BuiltinSpriteProvider> CODEC = RecordCodecBuilder.mapCodec(i -> i.group((App)Codec.unboundedMap((Codec)class_2960.field_25139, TexSource.CODEC).fieldOf("sources").forGetter(BuiltinSpriteProvider::sources), (App)class_2960.field_25139.optionalFieldOf("location").forGetter(s -> Optional.ofNullable(s.location()))).apply((Applicative)i, (sources, location) -> new BuiltinSpriteProvider((Map<class_2960, TexSource>)sources, location.orElse(null))));

    @Override
    public Map<class_2960, TexSource> getSources(ResourceGenerationContext context) {
        HashMap<class_2960, TexSource> outSources = new HashMap<class_2960, TexSource>(this.sources());
        if (this.location != null) {
            class_7654 converter = new class_7654(this.location.method_12836() + "/" + this.location.method_12832(), ".json");
            context.getResourceSource().listResources(this.location.method_12836() + "/" + this.location.method_12832(), rl -> rl.method_12832().endsWith(".json")).forEach((fileRl, resource) -> {
                class_2960 rl = converter.method_45115(fileRl);
                try (InputStreamReader reader = new InputStreamReader((InputStream)resource.get());){
                    JsonElement json = (JsonElement)DynamicAssetGenerator.GSON.fromJson((Reader)reader, JsonElement.class);
                    DataResult result = TexSource.CODEC.parse((DynamicOps)JsonOps.INSTANCE, (Object)json);
                    result.result().ifPresent(texSource -> outSources.put(rl, (TexSource)texSource));
                    result.error().ifPresent(partial -> DynamicAssetGenerator.LOGGER.error("Failed to load tex source json for " + String.valueOf(this.location) + ": " + String.valueOf(rl) + ": " + partial.message()));
                }
                catch (IOException e) {
                    DynamicAssetGenerator.LOGGER.error("Failed to load tex source json for " + String.valueOf(this.location) + ": " + String.valueOf(rl), (Throwable)e);
                }
            });
        }
        return outSources;
    }

    @Override
    public class_2960 getLocation() {
        return LOCATION;
    }
}

