/*
 * Decompiled with CFR 0.152.
 */
package dev.lukebemish.dynamicassetgenerator.impl;

import dev.lukebemish.dynamicassetgenerator.impl.DynamicAssetGenerator;
import dev.lukebemish.dynamicassetgenerator.impl.platform.Services;
import java.io.BufferedWriter;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.class_2960;

public class Timing {
    private static final boolean[] LOGGED = new boolean[2];
    private static final Map<String, Map<class_2960, Long>> partialTimes = new HashMap<String, Map<class_2960, Long>>();

    public static synchronized void recordPartialTime(String cache, class_2960 location, long time) {
        if (!partialTimes.containsKey(cache)) {
            partialTimes.put(cache, new HashMap());
        }
        partialTimes.get(cache).put(location, time);
    }

    public static synchronized void recordTime(String cache, class_2960 location, long time) {
        block17: {
            Path file;
            Map<class_2960, Long> map = partialTimes.get(cache);
            if (map != null) {
                time += map.get(location).longValue();
            }
            if (!Files.exists(Services.PLATFORM.getModDataFolder(), new LinkOption[0])) {
                try {
                    Files.createDirectories(Services.PLATFORM.getModDataFolder(), new FileAttribute[0]);
                }
                catch (IOException e) {
                    if (!LOGGED[0]) {
                        DynamicAssetGenerator.LOGGER.error("Issue creating mod data folder", (Throwable)e);
                        Timing.LOGGED[0] = true;
                    }
                    return;
                }
            }
            if (!Files.exists(file = Services.PLATFORM.getModDataFolder().resolve("times.log"), new LinkOption[0])) {
                try {
                    Files.createFile(file, new FileAttribute[0]);
                }
                catch (IOException e) {
                    if (!LOGGED[1]) {
                        DynamicAssetGenerator.LOGGER.error("Issue writing to times.log", (Throwable)e);
                        Timing.LOGGED[1] = true;
                    }
                    return;
                }
            }
            try (BufferedWriter writer = Files.newBufferedWriter(file, StandardCharsets.UTF_8, StandardOpenOption.APPEND);){
                writer.write(cache + " " + String.valueOf(location) + " " + time + "\n");
            }
            catch (IOException e) {
                if (LOGGED[1]) break block17;
                DynamicAssetGenerator.LOGGER.error("Issue writing to times.log", (Throwable)e);
                Timing.LOGGED[1] = true;
            }
        }
    }
}

