/*
 * Decompiled with CFR 0.152.
 */
package dev.lukebemish.dynamicassetgenerator.api.colors;

import dev.lukebemish.dynamicassetgenerator.api.colors.ColorTypes;
import net.minecraft.class_3532;
import org.jetbrains.annotations.Contract;

public abstract class LongColorType {
    @Contract(pure=true)
    public final int alpha(long color) {
        return (int)(color >> 48) & 0xFFFF;
    }

    @Contract(pure=true)
    protected final int first(long color) {
        return (int)(color >> 32) & 0xFFFF;
    }

    @Contract(pure=true)
    protected final int second(long color) {
        return (int)(color >> 16) & 0xFFFF;
    }

    @Contract(pure=true)
    protected final int third(long color) {
        return (int)(color & 0xFFFFL);
    }

    @Contract(pure=true)
    public abstract long toARGB64(long var1);

    @Contract(pure=true)
    public abstract long fromARGB64(long var1);

    @Contract(pure=true)
    public long color(int alpha, int first, int second, int third) {
        return (long)alpha << 48 | (long)first << 32 | (long)second << 16 | (long)third;
    }

    public static abstract class BlendingLongColorType
    extends LongColorType {
        @Contract(pure=true)
        public long alphaBlend(long over, long under) {
            int aUnder;
            int aOver = this.alpha(over);
            int a = aOver + (aUnder = this.alpha(under)) * (65535 - aOver) / 65535;
            if (a == 0) {
                return 0L;
            }
            int c1 = (this.first(over) * aOver + this.first(under) * aUnder * (65535 - aOver) / 65535) / a;
            int c2 = (this.second(over) * aOver + this.second(under) * aUnder * (65535 - aOver) / 65535) / a;
            int c3 = (this.third(over) * aOver + this.third(under) * aUnder * (65535 - aOver) / 65535) / a;
            return this.color(a, c1, c2, c3);
        }
    }

    public static abstract class HueLongColorType
    extends LongColorType {
        @Contract(pure=true)
        protected abstract float makeChroma(long var1);

        @Contract(pure=true)
        public int hue(long color) {
            return this.first(color);
        }

        @Contract(pure=true)
        private float makeLimitedRed(float chroma, int hue) {
            float hPrime = (float)hue / 10922.5f;
            float x = chroma * (1.0f - Math.abs(hPrime % 2.0f - 1.0f));
            if (hPrime < 1.0f) {
                return chroma;
            }
            if (hPrime < 2.0f) {
                return x;
            }
            if (hPrime < 4.0f) {
                return 0.0f;
            }
            if (hPrime < 5.0f) {
                return x;
            }
            return chroma;
        }

        @Contract(pure=true)
        private float makeLimitedGreen(float chroma, int hue) {
            float hPrime = (float)hue / 10922.5f;
            float x = chroma * (1.0f - Math.abs(hPrime % 2.0f - 1.0f));
            if (hPrime < 1.0f) {
                return x;
            }
            if (hPrime < 3.0f) {
                return chroma;
            }
            if (hPrime < 4.0f) {
                return x;
            }
            return 0.0f;
        }

        @Contract(pure=true)
        private float makeLimitedBlue(float chroma, int hue) {
            float hPrime = (float)hue / 10922.5f;
            float x = chroma * (1.0f - Math.abs(hPrime % 2.0f - 1.0f));
            if (hPrime < 2.0f) {
                return 0.0f;
            }
            if (hPrime < 3.0f) {
                return x;
            }
            if (hPrime < 5.0f) {
                return chroma;
            }
            return x;
        }

        @Contract(pure=true)
        protected abstract float makeMatch(long var1, float var3);

        @Override
        public long toARGB64(long color) {
            float chroma = this.makeChroma(color);
            int hue = this.hue(color);
            float m = this.makeMatch(color, chroma);
            float r = this.makeLimitedRed(chroma, hue) + m;
            float g = this.makeLimitedGreen(chroma, hue) + m;
            float b = this.makeLimitedBlue(chroma, hue) + m;
            return ColorTypes.ARGB64.color(this.alpha(color), Math.round(r * 65535.0f) & 0xFFFF, Math.round(g * 65535.0f) & 0xFFFF, Math.round(b * 65535.0f) & 0xFFFF);
        }

        @Override
        public long fromARGB64(long color) {
            int r = ColorTypes.ARGB64.red(color);
            int g = ColorTypes.ARGB64.green(color);
            int b = ColorTypes.ARGB64.blue(color);
            int xMax = Math.max(Math.max(r, g), b);
            int xMin = Math.min(Math.min(r, g), b);
            int chroma = xMax - xMin;
            int m = xMax == r ? 0 : (xMax == g ? 1 : 2);
            int h = 0;
            float fR = (float)r / 65535.0f;
            float fG = (float)g / 65535.0f;
            float fB = (float)b / 65535.0f;
            float fChroma = (float)chroma / 65535.0f;
            if (chroma != 0) {
                float fH = switch (m) {
                    case 0 -> {
                        float value = (fG - fB) / fChroma;
                        if (value < 0.0f) {
                            yield value + 6.0f;
                        }
                        yield value;
                    }
                    case 1 -> (fB - fR) / fChroma + 2.0f;
                    default -> (fR - fG) / fChroma + 4.0f;
                };
                h = class_3532.method_15340((int)Math.round(fH / 6.0f * 65535.0f), (int)0, (int)65535);
            }
            return this.makeColor(ColorTypes.ARGB64.alpha(color), h, fChroma, (float)xMin / 65535.0f, (float)xMax / 65535.0f);
        }

        @Contract(pure=true)
        protected abstract long makeColor(int var1, int var2, float var3, float var4, float var5);
    }
}

