/*
 * Decompiled with CFR 0.152.
 */
package dev.lukebemish.dynamicassetgenerator.api.client.image;

import com.mojang.datafixers.util.Pair;
import dev.lukebemish.dynamicassetgenerator.api.colors.ColorTypes;
import dev.lukebemish.dynamicassetgenerator.api.colors.Palette;
import dev.lukebemish.dynamicassetgenerator.api.colors.operations.PointwiseOperation;
import dev.lukebemish.dynamicassetgenerator.impl.util.Maath;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import java.util.List;
import java.util.stream.IntStream;
import net.minecraft.class_1011;
import org.apache.logging.log4j.util.TriConsumer;

public final class ImageUtils {
    private ImageUtils() {
    }

    public static Palette getPalette(class_1011 image, double cutoff) {
        Palette palette = new Palette(cutoff);
        for (int i = 0; i < image.method_4307(); ++i) {
            for (int j = 0; j < image.method_4323(); ++j) {
                int color = ImageUtils.safeGetPixelARGB(image, i, j);
                if (ColorTypes.ARGB32.alpha(color) == 0) continue;
                palette.add(color);
            }
        }
        return palette;
    }

    public static Palette getPalette(class_1011 image) {
        return ImageUtils.getPalette(image, 3.5);
    }

    public static int safeGetPixelABGR(class_1011 image, int x, int y, int def) {
        if (x < 0 || x >= image.method_4307() || y < 0 || y >= image.method_4323()) {
            return def;
        }
        return image.method_4315(x, y);
    }

    public static int safeGetPixelABGR(class_1011 image, int x, int y) {
        return ImageUtils.safeGetPixelABGR(image, x, y, 0);
    }

    public static boolean safeSetPixelABGR(class_1011 image, int x, int y, int color) {
        if (x < 0 || x >= image.method_4307() || y < 0 || y >= image.method_4323()) {
            return false;
        }
        image.method_4305(x, y, color);
        return true;
    }

    public static int safeGetPixelARGB(class_1011 image, int x, int y, int def) {
        if (x < 0 || x >= image.method_4307() || y < 0 || y >= image.method_4323()) {
            return def;
        }
        return ColorTypes.ABGR32.toARGB32(image.method_4315(x, y));
    }

    public static int safeGetPixelARGB(class_1011 image, int x, int y) {
        return ImageUtils.safeGetPixelARGB(image, x, y, 0);
    }

    public static boolean safeSetPixelARGB(class_1011 image, int x, int y, int color) {
        if (x < 0 || x >= image.method_4307() || y < 0 || y >= image.method_4323()) {
            return false;
        }
        image.method_4305(x, y, ColorTypes.ABGR32.fromARGB32(color));
        return true;
    }

    public static Pair<Integer, Integer> calculateScaledSize(List<class_1011> images) {
        IntArrayList widths = new IntArrayList(images.size());
        IntArrayList heights = new IntArrayList(images.size());
        for (class_1011 image : images) {
            widths.add(image.method_4307());
            heights.add(image.method_4323());
        }
        int maxWidth = Maath.lcm((List<Integer>)widths);
        int maxHeight = 0;
        for (int i = 0; i < images.size(); ++i) {
            int scaledHeight = maxWidth / widths.getInt(i) * heights.getInt(i);
            if (scaledHeight <= maxHeight) continue;
            maxHeight = scaledHeight;
        }
        return Pair.of((Object)maxWidth, (Object)maxHeight);
    }

    public static <T> void applyScaledOperation(PointwiseOperation<T> pointwiseOperation, OperationResultConsumer<T> consumer, List<class_1011> images) {
        if (pointwiseOperation.expectedImages() != images.size() && pointwiseOperation.expectedImages() != -1) {
            throw new IllegalArgumentException("Expected " + pointwiseOperation.expectedImages() + " images, got " + images.size());
        }
        Pair<Integer, Integer> scaledSize = ImageUtils.calculateScaledSize(images);
        int width = (Integer)scaledSize.getFirst();
        int height = (Integer)scaledSize.getSecond();
        int numImages = images.size();
        for (int i = 0; i < width; ++i) {
            for (int j = 0; j < height; ++j) {
                int[] colors = new int[numImages];
                boolean[] inBounds = new boolean[numImages];
                for (int k = 0; k < numImages; ++k) {
                    int x = i * images.get(k).method_4307() / width;
                    int y = j * images.get(k).method_4323() / height;
                    colors[k] = ImageUtils.safeGetPixelARGB(images.get(k), x, y, 0);
                    inBounds[k] = x >= 0 && x < images.get(k).method_4307() && y >= 0 && y < images.get(k).method_4323();
                }
                T t = pointwiseOperation.apply(colors, inBounds);
                consumer.accept(i, j, t);
            }
        }
    }

    public static <T> void applyParallelScaledOperation(PointwiseOperation<T> pointwiseOperation, OperationResultConsumer<T> consumer, List<class_1011> images) {
        if (pointwiseOperation.expectedImages() != images.size() && pointwiseOperation.expectedImages() != -1) {
            throw new IllegalArgumentException("Expected " + pointwiseOperation.expectedImages() + " images, got " + images.size());
        }
        Pair<Integer, Integer> scaledSize = ImageUtils.calculateScaledSize(images);
        int width = (Integer)scaledSize.getFirst();
        int height = (Integer)scaledSize.getSecond();
        int numImages = images.size();
        IntStream.range(0, width).parallel().forEach(i -> {
            for (int j = 0; j < height; ++j) {
                int[] colors = new int[numImages];
                boolean[] inBounds = new boolean[numImages];
                for (int k = 0; k < numImages; ++k) {
                    int x = i * ((class_1011)images.get(k)).method_4307() / width;
                    int y = j * ((class_1011)images.get(k)).method_4323() / height;
                    colors[k] = ImageUtils.safeGetPixelARGB((class_1011)images.get(k), x, y, 0);
                    inBounds[k] = x >= 0 && x < ((class_1011)images.get(k)).method_4307() && y >= 0 && y < ((class_1011)images.get(k)).method_4323();
                }
                Object t = pointwiseOperation.apply(colors, inBounds);
                consumer.accept(i, j, t);
            }
        });
    }

    public static class_1011 generateScaledImage(PointwiseOperation<Integer> pointwiseOperation, List<class_1011> images) {
        Pair<Integer, Integer> scaledSize = ImageUtils.calculateScaledSize(images);
        int width = (Integer)scaledSize.getFirst();
        int height = (Integer)scaledSize.getSecond();
        class_1011 out = new class_1011(width, height, false);
        ImageUtils.applyParallelScaledOperation(pointwiseOperation, (x, y, color) -> ImageUtils.safeSetPixelARGB(out, x, y, color), images);
        return out;
    }

    @FunctionalInterface
    public static interface OperationResultConsumer<T>
    extends TriConsumer<Integer, Integer, T> {
        public void acceptResult(int var1, int var2, T var3);

        default public void accept(Integer integer, Integer integer2, T t) {
            this.acceptResult(integer, integer2, t);
        }
    }
}

