/*
 * Decompiled with CFR 0.152.
 */
package dev.lukebemish.dynamicassetgenerator.api.client.generators.texsources;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.lukebemish.dynamicassetgenerator.api.ResourceGenerationContext;
import dev.lukebemish.dynamicassetgenerator.api.client.generators.TexSource;
import dev.lukebemish.dynamicassetgenerator.api.client.generators.TexSourceDataHolder;
import java.io.IOException;
import java.io.InputStream;
import java.util.Base64;
import java.util.Objects;
import net.minecraft.class_1011;
import net.minecraft.class_2960;
import net.minecraft.class_7367;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

public final class TextureReaderSource
implements TexSource {
    public static final MapCodec<TextureReaderSource> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)class_2960.field_25139.fieldOf("path").forGetter(TextureReaderSource::getPath)).apply((Applicative)instance, TextureReaderSource::new));
    private final class_2960 path;

    private TextureReaderSource(class_2960 path) {
        this.path = path;
    }

    @Override
    public @NonNull MapCodec<? extends TexSource> codec() {
        return CODEC;
    }

    @Override
    public class_7367<class_1011> getSupplier(TexSourceDataHolder data, ResourceGenerationContext context) {
        class_2960 outRl = class_2960.method_60655((String)this.getPath().method_12836(), (String)("textures/" + this.getPath().method_12832() + ".png"));
        return () -> {
            try {
                class_7367<InputStream> in = context.getResourceSource().getResource(outRl);
                if (in != null) {
                    return class_1011.method_4309((InputStream)((InputStream)in.get()));
                }
                data.getLogger().error("Texture not available in context: {}", (Object)this.getPath());
            }
            catch (IOException e) {
                String message = "Issue loading texture: " + String.valueOf(this.getPath());
                data.getLogger().error(message);
                throw new IOException(message, e);
            }
            throw new IOException("Issue loading texture: " + String.valueOf(this.getPath()));
        };
    }

    @Override
    public <T> @NonNull DataResult<T> persistentCacheData(DynamicOps<T> ops, ResourceGenerationContext context) {
        class_2960 outRl = class_2960.method_60655((String)this.getPath().method_12836(), (String)("textures/" + this.getPath().method_12832() + ".png"));
        class_7367<InputStream> supplier = context.getResourceSource().getResource(outRl);
        if (supplier != null) {
            DataResult dataResult;
            block9: {
                InputStream is = (InputStream)supplier.get();
                try {
                    byte[] bytes = is.readAllBytes();
                    String string = Base64.getEncoder().encodeToString(bytes);
                    dataResult = DataResult.success((Object)ops.createString(string));
                    if (is == null) break block9;
                }
                catch (Throwable throwable) {
                    try {
                        if (is != null) {
                            try {
                                is.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (IOException ignored) {
                        return DataResult.error(() -> "Cannot cache potentially erroring source");
                    }
                }
                is.close();
            }
            return dataResult;
        }
        return TexSource.super.persistentCacheData(ops, context);
    }

    public class_2960 getPath() {
        return this.path;
    }

    public static class Builder {
        private @Nullable class_2960 path;

        public Builder setPath(class_2960 path) {
            this.path = path;
            return this;
        }

        public TextureReaderSource build() {
            Objects.requireNonNull(this.path);
            return new TextureReaderSource(this.path);
        }
    }
}

