/*
 * Decompiled with CFR 0.152.
 */
package dev.lukebemish.dynamicassetgenerator.api.client;

import com.google.gson.Gson;
import com.google.gson.JsonObject;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.MapCodec;
import dev.lukebemish.dynamicassetgenerator.api.ResourceGenerationContext;
import dev.lukebemish.dynamicassetgenerator.api.TrackingResourceSource;
import dev.lukebemish.dynamicassetgenerator.api.cache.CacheMetaJsonOps;
import dev.lukebemish.dynamicassetgenerator.api.client.generators.TexSource;
import dev.lukebemish.dynamicassetgenerator.api.client.generators.TexSourceDataHolder;
import dev.lukebemish.dynamicassetgenerator.api.client.generators.TextureMetaGenerator;
import dev.lukebemish.dynamicassetgenerator.impl.DynamicAssetGenerator;
import dev.lukebemish.dynamicassetgenerator.impl.ResourceCachingData;
import dev.lukebemish.dynamicassetgenerator.impl.client.ForegroundExtractor;
import dev.lukebemish.dynamicassetgenerator.impl.client.TexSourceCache;
import dev.lukebemish.dynamicassetgenerator.impl.client.platform.ClientServices;
import dev.lukebemish.dynamicassetgenerator.impl.mixin.SpriteSourcesAccessor;
import dev.lukebemish.dynamicassetgenerator.impl.util.ResourceUtils;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.minecraft.class_1011;
import net.minecraft.class_1079;
import net.minecraft.class_2960;
import net.minecraft.class_3264;
import net.minecraft.class_3270;
import net.minecraft.class_3298;
import net.minecraft.class_3300;
import net.minecraft.class_3518;
import net.minecraft.class_7367;
import net.minecraft.class_7368;
import net.minecraft.class_7764;
import net.minecraft.class_7771;
import net.minecraft.class_7948;
import net.minecraft.class_7951;
import org.jetbrains.annotations.ApiStatus;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

public interface SpriteProvider<T extends SpriteProvider<T>> {
    public Map<class_2960, TexSource> getSources(ResourceGenerationContext var1);

    public class_2960 getLocation();

    public static <T extends SpriteProvider<T>> void register(class_2960 location, MapCodec<T> codec) {
        ClientServices.PLATFORM_CLIENT.addSpriteSource(location, (MapCodec<? extends class_7948>)codec.xmap(SpriteProvider::wrap, Wrapper::unwrap));
    }

    public static <T extends SpriteProvider<T>> void register(class_2960 location, Supplier<T> constructor) {
        ClientServices.PLATFORM_CLIENT.addSpriteSource(location, (MapCodec<? extends class_7948>)MapCodec.unit(() -> ((SpriteProvider)constructor.get()).wrap()));
    }

    default public void reset(ResourceGenerationContext context) {
        TexSourceCache.reset(context);
        ForegroundExtractor.reset(context);
    }

    default public void run(final class_3300 resourceManager, class_7948.class_7949 output, final class_2960 cacheName) {
        ResourceGenerationContext context = new ResourceGenerationContext(){
            private final ResourceGenerationContext.ResourceSource source = ResourceGenerationContext.ResourceSource.filtered(pack -> true, class_3264.field_14188, () -> ((class_3300)resourceManager).method_29213()).fallback(new ResourceGenerationContext.ResourceSource(){

                @Override
                public @Nullable class_7367<InputStream> getResource(@NonNull class_2960 location) {
                    return resourceManager.method_14486(location).map(r -> () -> ((class_3298)r).method_14482()).orElse(null);
                }

                @Override
                public List<class_7367<InputStream>> getResourceStack(@NonNull class_2960 location) {
                    return resourceManager.method_14489(location).stream().map(r -> () -> ((class_3298)r).method_14482()).toList();
                }

                @Override
                public Map<class_2960, class_7367<InputStream>> listResources(@NonNull String path, @NonNull Predicate<class_2960> filter) {
                    HashMap<class_2960, class_7367<InputStream>> map = new HashMap<class_2960, class_7367<InputStream>>();
                    resourceManager.method_14488(path, filter).forEach((rl, r) -> map.put((class_2960)rl, () -> ((class_3298)r).method_14482()));
                    return map;
                }

                @Override
                public Map<class_2960, List<class_7367<InputStream>>> listResourceStacks(@NonNull String path, @NonNull Predicate<class_2960> filter) {
                    HashMap<class_2960, List<class_7367<InputStream>>> map = new HashMap<class_2960, List<class_7367<InputStream>>>();
                    resourceManager.method_41265(path, filter).forEach((rl, r) -> map.put((class_2960)rl, (List<class_7367<InputStream>>)r.stream().map(i -> () -> ((class_3298)i).method_14482()).toList()));
                    return map;
                }

                @Override
                public @NonNull Set<String> getNamespaces() {
                    return resourceManager.method_14487();
                }
            });

            @Override
            public @NonNull class_2960 getCacheName() {
                return cacheName;
            }

            @Override
            public ResourceGenerationContext.ResourceSource getResourceSource() {
                return this.source;
            }
        };
        this.reset(context);
        Map<class_2960, TexSource> sources = this.getSources(context);
        sources.forEach((rl, texSource) -> {
            TrackingResourceSource trackingSource = TrackingResourceSource.of(context.getResourceSource(), "textures", ".png");
            ResourceGenerationContext trackingContext = context.withResourceSource(trackingSource);
            TexSourceDataHolder dataHolder = new TexSourceDataHolder();
            class_7367<class_1011> imageSupplier = ResourceUtils.wrapSafeData(class_2960.method_60655((String)rl.method_12836(), (String)("textures/" + rl.method_12832() + ".png")), (r, c) -> texSource.getCachedSupplier(dataHolder, (ResourceGenerationContext)c), trackingContext, im -> {
                try (class_1011 image = im;){
                    ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(image.method_24036());
                    return byteArrayInputStream;
                }
            }, is -> {
                try (InputStream input = is;){
                    class_1011 class_10112 = class_1011.method_4309((InputStream)input);
                    return class_10112;
                }
            }, (r, c) -> {
                CacheMetaJsonOps ops = new CacheMetaJsonOps();
                ops.putData(ResourceCachingData.class, new ResourceCachingData((class_2960)r, (ResourceGenerationContext)c));
                return TexSource.CODEC.encodeStart((DynamicOps)ops, texSource).result().map(arg_0 -> ((Gson)DynamicAssetGenerator.GSON_FLAT).toJson(arg_0)).orElse(null);
            });
            output.method_47670(rl, spriteResourceLoader -> {
                try {
                    if (imageSupplier == null) {
                        throw new IOException("No image supplier");
                    }
                    class_1011 image = (class_1011)imageSupplier.get();
                    class_1079 section = class_1079.field_21768;
                    if (!trackingSource.getTouchedTextures().isEmpty()) {
                        TextureMetaGenerator.AnimationGenerator generator = new TextureMetaGenerator.AnimationGenerator.Builder().build();
                        ArrayList<Pair<class_2960, JsonObject>> animations = new ArrayList<Pair<class_2960, JsonObject>>();
                        for (class_2960 touchedTexture : trackingSource.getTouchedTextures()) {
                            class_7367<InputStream> resource = context.getResourceSource().getResource(class_2960.method_60655((String)touchedTexture.method_12836(), (String)("textures/" + touchedTexture.method_12832() + ".png.mcmeta")));
                            if (resource == null) {
                                animations.add((Pair<class_2960, JsonObject>)new Pair((Object)touchedTexture, null));
                                continue;
                            }
                            try (BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)resource.get()));){
                                JsonObject json = (JsonObject)DynamicAssetGenerator.GSON.fromJson((Reader)reader, JsonObject.class);
                                JsonObject animation = class_3518.method_15296((JsonObject)json, (String)"animation");
                                animations.add((Pair<class_2960, JsonObject>)new Pair((Object)touchedTexture, (Object)animation));
                            }
                            catch (Exception ignored) {
                                animations.add((Pair<class_2960, JsonObject>)new Pair((Object)touchedTexture, null));
                            }
                        }
                        JsonObject built = generator.apply(animations);
                        if (built != null) {
                            try {
                                section = class_1079.field_5337.method_4692(built);
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                        }
                    }
                    class_7771 frameSize = new class_7771(image.method_4307(), image.method_4323());
                    if (section != class_1079.field_21768) {
                        frameSize = section.method_24143(image.method_4307(), image.method_4323());
                    }
                    return new class_7764(rl, frameSize, image, new class_7368.class_8622().method_52448((class_3270)class_1079.field_5337, (Object)section).method_52447());
                }
                catch (IOException e) {
                    DynamicAssetGenerator.LOGGER.error("Failed to generate texture for sprite source type " + String.valueOf(this.getLocation()) + " at " + String.valueOf(rl) + ": ", (Throwable)e);
                    return null;
                }
            });
        });
    }

    default public Wrapper<T> wrap() {
        return new Wrapper<SpriteProvider>(this, null);
    }

    public static final class Wrapper<T extends SpriteProvider<T>>
    implements class_7948 {
        private final T source;
        private final @Nullable class_2960 location;

        private Wrapper(T source, @Nullable class_2960 location) {
            this.source = source;
            this.location = location;
        }

        public void method_47673(class_3300 resourceManager, class_7948.class_7949 output) {
            class_2960 cacheName = this.location == null ? this.source.getLocation() : this.source.getLocation().method_48331("__" + this.location.method_12836() + "__" + this.location.method_12832());
            this.source.run(resourceManager, output, cacheName);
        }

        public @NonNull class_7951 method_47672() {
            return (class_7951)SpriteSourcesAccessor.dynamic_asset_generator$getTypes().get((Object)this.source.getLocation());
        }

        public T unwrap() {
            return this.source;
        }

        @ApiStatus.Internal
        public Wrapper<T> withLocation(class_2960 atlasLocation) {
            return new Wrapper<T>(this.source, atlasLocation);
        }
    }
}

