/*
 * Decompiled with CFR 0.152.
 */
package dev.lukebemish.dynamicassetgenerator.api;

import dev.lukebemish.dynamicassetgenerator.api.ResourceGenerationContext;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import net.minecraft.class_2960;
import net.minecraft.class_7367;
import org.jetbrains.annotations.Contract;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

public class TrackingResourceSource
implements ResourceGenerationContext.ResourceSource {
    private final ResourceGenerationContext.ResourceSource delegate;
    private final List<class_2960> touchedTextures = new ArrayList<class_2960>();
    private final Set<class_2960> touchedTexturesSet = new HashSet<class_2960>();
    private final List<class_2960> view = Collections.unmodifiableList(this.touchedTextures);
    private final String prefix;
    private final String suffix;

    public List<class_2960> getTouchedTextures() {
        return this.view;
    }

    private TrackingResourceSource(ResourceGenerationContext.ResourceSource delegate, String prefix, String suffix) {
        this.delegate = delegate;
        this.prefix = prefix.endsWith("/") ? prefix : prefix + "/";
        this.suffix = suffix;
    }

    @Contract(value="_, _, _ -> new")
    public static TrackingResourceSource of(ResourceGenerationContext.ResourceSource delegate, String prefix, String suffix) {
        return new TrackingResourceSource(delegate, prefix, suffix);
    }

    private void addLocation(class_2960 location) {
        if (location.method_12832().startsWith(this.prefix) && location.method_12832().endsWith(this.suffix)) {
            this.unsafeAddLocation(class_2960.method_60655((String)location.method_12836(), (String)location.method_12832().substring(this.prefix.length(), location.method_12832().length() - this.suffix.length())));
        }
    }

    private synchronized void unsafeAddLocation(class_2960 location) {
        if (this.touchedTexturesSet.add(location)) {
            this.touchedTextures.add(location);
        }
    }

    @Override
    public @Nullable class_7367<InputStream> getResource(@NonNull class_2960 location) {
        this.addLocation(location);
        return this.delegate.getResource(location);
    }

    @Override
    public List<class_7367<InputStream>> getResourceStack(@NonNull class_2960 location) {
        this.addLocation(location);
        return this.delegate.getResourceStack(location);
    }

    @Override
    public Map<class_2960, class_7367<InputStream>> listResources(@NonNull String path, @NonNull Predicate<class_2960> filter) {
        Map<class_2960, class_7367<InputStream>> resources = this.delegate.listResources(path, filter);
        resources.keySet().forEach(this::addLocation);
        return resources;
    }

    @Override
    public Map<class_2960, List<class_7367<InputStream>>> listResourceStacks(@NonNull String path, @NonNull Predicate<class_2960> filter) {
        Map<class_2960, List<class_7367<InputStream>>> resources = this.delegate.listResourceStacks(path, filter);
        resources.keySet().forEach(this::addLocation);
        return resources;
    }

    @Override
    public @NonNull Set<String> getNamespaces() {
        return this.delegate.getNamespaces();
    }
}

