/*
 * Decompiled with CFR 0.152.
 */
package dev.lukebemish.dynamicassetgenerator.api;

import com.google.gson.JsonElement;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.MapCodec;
import dev.lukebemish.dynamicassetgenerator.api.PathAwareInputStreamSource;
import dev.lukebemish.dynamicassetgenerator.api.ResourceGenerationContext;
import dev.lukebemish.dynamicassetgenerator.api.cache.CacheMetaCodec;
import dev.lukebemish.dynamicassetgenerator.api.cache.CacheMetaJsonOps;
import dev.lukebemish.dynamicassetgenerator.api.cache.DataConsumer;
import dev.lukebemish.dynamicassetgenerator.impl.CommonRegisters;
import dev.lukebemish.dynamicassetgenerator.impl.DynamicAssetGenerator;
import dev.lukebemish.dynamicassetgenerator.impl.ResourceCachingData;
import java.util.List;
import java.util.function.Function;
import net.minecraft.class_2960;
import org.jetbrains.annotations.ApiStatus;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

public interface ResourceGenerator
extends PathAwareInputStreamSource {
    @ApiStatus.Internal
    public static final String PERSISTENT_CACHE_KEY = "__dynamic_asset_generator_persistent";
    public static final Codec<ResourceGenerator> CODEC = CacheMetaCodec.of(Codec.lazyInitialized(() -> new Codec<MapCodec<? extends ResourceGenerator>>(){

        public <T> DataResult<Pair<MapCodec<? extends ResourceGenerator>, T>> decode(DynamicOps<T> ops, T input) {
            return class_2960.field_25139.decode(ops, input).flatMap(keyValuePair -> !CommonRegisters.RESOURCEGENERATORS.containsKey(keyValuePair.getFirst()) ? DataResult.error(() -> "Unknown dynamic resource generator type: " + String.valueOf(keyValuePair.getFirst())) : DataResult.success((Object)keyValuePair.mapFirst(arg_0 -> CommonRegisters.RESOURCEGENERATORS.get(arg_0))));
        }

        public <T> DataResult<T> encode(MapCodec<? extends ResourceGenerator> input, DynamicOps<T> ops, T prefix) {
            class_2960 key = (class_2960)CommonRegisters.RESOURCEGENERATORS.inverse().get(input);
            if (key == null) {
                return DataResult.error(() -> "Unregistered dynamic resource generator type: " + String.valueOf(input));
            }
            Object toMerge = ops.createString(key.toString());
            return ops.mergeToPrimitive(prefix, toMerge);
        }
    }).dispatch(ResourceGenerator::codec, Function.identity()), List.of(CacheMetaCodec.SingleCacheType.of(new DataConsumer<ResourceCachingData, ResourceGenerator>(){

        @Override
        public <T> @NonNull DataResult<T> encode(DynamicOps<T> ops, ResourceCachingData data, ResourceGenerator object) {
            return object.persistentCacheData(ops, data.location(), data.context());
        }
    }, "__dynamic_asset_generator_persistent", ResourceCachingData.class)));

    public static void register(class_2960 rl, MapCodec<? extends ResourceGenerator> reader) {
        CommonRegisters.RESOURCEGENERATORS.put((Object)rl, reader);
    }

    public MapCodec<? extends ResourceGenerator> codec();

    @Override
    @ApiStatus.NonExtendable
    default public @Nullable String createCacheKey(class_2960 outRl, ResourceGenerationContext context) {
        CacheMetaJsonOps ops = new CacheMetaJsonOps();
        ops.putData(ResourceCachingData.class, new ResourceCachingData(outRl, context));
        DataResult result = CODEC.encodeStart((DynamicOps)ops, (Object)this);
        JsonElement element = result.result().orElse(null);
        if (element != null) {
            return DynamicAssetGenerator.GSON_FLAT.toJson(element);
        }
        return PathAwareInputStreamSource.super.createCacheKey(outRl, context);
    }

    @ApiStatus.Experimental
    default public <T> @NonNull DataResult<T> persistentCacheData(DynamicOps<T> ops, class_2960 location, ResourceGenerationContext context) {
        return DataResult.error(() -> "Resource generators must be made explicitly cacheable by implementing the relevant API");
    }
}

