package dev.lukebemish.dynamicassetgenerator.impl.fabriquilt.fabric;

import dev.lukebemish.dynamicassetgenerator.impl.fabriquilt.FabriQuiltShared;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_3262;
import net.minecraft.class_3264;
import net.minecraft.class_3285;
import java.nio.file.Path;
import java.util.function.Function;
import java.util.stream.Stream;

public class FabricPlatform implements FabriQuiltShared {
    public static final FabriQuiltShared INSTANCE = new FabricPlatform();

    @Override
    public void packForType(class_3264 type, class_3285 source) {
        PackPlanner.forType(type).register(source);
    }

    @Override
    public boolean isModLoaded(String id) {
        return FabricLoader.getInstance().isModLoaded(id);
    }

    @Override
    public String modVersion(String id) {
        return FabricLoader.getInstance().getModContainer(id).orElseThrow().getMetadata().getVersion().getFriendlyString();
    }

    @Override
    public Path configDir() {
        return FabricLoader.getInstance().getConfigDir();
    }

    @Override
    public Path cacheDir() {
        return FabricLoader.getInstance().getGameDir().resolve(".cache");
    }

    @Override
    public Stream<class_3262> unpackPacks(Stream<? extends class_3262> packs) {
        return packs.map(Function.identity());
    }
}
