package dev.lukebemish.dynamicassetgenerator.impl;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import dev.lukebemish.dynamicassetgenerator.api.ResourceCache;
import dev.lukebemish.dynamicassetgenerator.api.ResourceGenerator;
import dev.lukebemish.dynamicassetgenerator.api.generators.DummyGenerator;
import dev.lukebemish.dynamicassetgenerator.impl.platform.Services;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jspecify.annotations.Nullable;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import net.minecraft.class_155;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3272;
import net.minecraft.class_3288;

public class DynamicAssetGenerator {
    public static final Gson GSON = new GsonBuilder().setPrettyPrinting().setLenient().create();
    public static final Gson GSON_FLAT = new GsonBuilder().setLenient().create();
    public static final String MOD_ID = "dynamic_asset_generator";
    public static final String SOURCE_JSON_DIR = MOD_ID +"/generators";
    public static final Logger LOGGER = LogManager.getLogger(MOD_ID);

    public static class_3272 makeMetadata(ResourceCache cache) {
        return new class_3272(
            class_2561.method_43470(DynamicAssetGenerator.MOD_ID + '/' + cache.getName()),
                class_155.method_16673().method_48017(cache.getPackType()),
            Optional.empty()
        );
    }

    private static @Nullable ModConfig configs;

    public static ModConfig getConfig() {
        if (configs == null) {
            configs = ModConfig.get();
        }
        return configs;
    }

    public static final boolean TIME_RESOURCES = "true".equals(System.getProperty("dynamicassetgenerator.time_resources"))  || getConfig().timeResources();

    public static void init() {
        ResourceGenerator.register(class_2960.method_60655(MOD_ID,"dummy"), DummyGenerator.CODEC);
        if (TIME_RESOURCES) {
            LOGGER.info("Dynamic Asset Generator will time resource generation during this run!");
            try {
                Files.deleteIfExists(Services.PLATFORM.getModDataFolder().resolve("times.log"));
            } catch (IOException e) {
                LOGGER.error("Issue deleting times.log; you might be able to ignore this", e);
            }
        }
        ResourceCache.register(new BuiltinDataResourceCache(class_2960.method_60655(MOD_ID, "builtin_data")), class_3288.class_3289.field_14280);
    }

    public static Path cache(class_2960 cacheKey, boolean keyed) {
        return Services.PLATFORM.getModDataFolder().resolve(keyed ? "keyed_cache" : "cache").resolve(cacheKey.method_12836()).resolve(cacheKey.method_12832());
    }

    public static final Map<class_2960, PackInfo> CACHES = new HashMap<>();

    public static void registerCache(class_2960 id, ResourceCache cache, class_3288.class_3289 position) {
        CACHES.put(id, new PackInfo(cache, position));
    }

    public record PackInfo(ResourceCache cache, class_3288.class_3289 position) {

    }
}
