package dev.lukebemish.dynamicassetgenerator.api.util;

import com.mojang.datafixers.util.Pair;
import net.minecraft.class_2960;

/**
 * A series of utilities for modifying {@link class_2960}s
 */
@SuppressWarnings("unused")
public final class LocationUtils {
    private LocationUtils() {}

    /**
     * Separates a prefixed location into its first prefix and the rest of the location.
     * @param location The location to separate.
     * @return A pair of the first prefix and the rest of the location.
     */
    public static Pair<String, class_2960> separatePrefix(class_2960 location) {
        String[] parts = location.method_12832().split("/", 2);
        if (parts.length == 1)
            return Pair.of("", location);
        return new Pair<>(parts[0], class_2960.method_60655(location.method_12836(), parts[1]));
    }

    /**
     * Separates the extension of a location from the rest of the path.
     * @param location The location to separate.
     * @return A pair of the extension and the location without the extension.
     */
    public static Pair<String, class_2960> separateSuffix(class_2960 location) {
        int index = location.method_12832().lastIndexOf('.');
        if (index == -1)
            return Pair.of("", location);
        return new Pair<>(location.method_12832().substring(index + 1), class_2960.method_60655(location.method_12836(), location.method_12832().substring(0, index)));
    }
}
