package dev.lukebemish.dynamicassetgenerator.api.generators;

import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.MapCodec;
import dev.lukebemish.dynamicassetgenerator.api.ResourceGenerationContext;
import dev.lukebemish.dynamicassetgenerator.api.ResourceGenerator;
import org.jspecify.annotations.NonNull;

import java.io.InputStream;
import java.util.Set;
import net.minecraft.class_2960;
import net.minecraft.class_7367;

/**
 * A resource generator that generates no resources. Useful for overriding other resource generators in lower priority
 * packs.
 */
public class DummyGenerator implements ResourceGenerator {
    public static final DummyGenerator INSTANCE = new DummyGenerator();
    public static final MapCodec<DummyGenerator> CODEC = MapCodec.unit(INSTANCE);

    private DummyGenerator() {}

    @Override
    public class_7367<InputStream> get(class_2960 outRl, ResourceGenerationContext context) {
        return null;
    }

    @Override
    public @NonNull Set<class_2960> getLocations(ResourceGenerationContext context) {
        return Set.of();
    }

    @Override
    public @NonNull <T> DataResult<T> persistentCacheData(DynamicOps<T> ops, class_2960 location, ResourceGenerationContext context) {
        return DataResult.success(ops.empty());
    }

    @Override
    public MapCodec<? extends ResourceGenerator> codec() {
        return CODEC;
    }
}
