package dev.lukebemish.dynamicassetgenerator.api.colors.operations;

import dev.lukebemish.dynamicassetgenerator.api.colors.Palette;
import net.minecraft.class_5253;


/**
 * A single-image pointwise operation that maps from a palette sample number to a color.
 */
@SuppressWarnings("unused")
public class PaletteToColorOperation implements PointwiseOperation.Unary<Integer> {
    private final Palette palette;

    public PaletteToColorOperation(Palette palette) {
        this.palette = palette;
    }

    public Palette getPalette() {
        return palette;
    }

    @Override
    public Integer apply(int color, boolean isInBounds) {
        if (!isInBounds)
            return 0;
        int value = ((color >> 16 & 0xFF) + (color >> 8 & 0xFF) + (color & 0xFF)) / 3;
        return (palette.getColor(value) & 0xFFFFFF) | (class_5253.class_5254.method_27762(color) << 24);
    }
}
