/*
 * Decompiled with CFR 0.152.
 */
package dev.lukebemish.dynamicassetgenerator.api.client.generators.texsources;

import com.mojang.blaze3d.platform.NativeImage;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.lukebemish.dynamicassetgenerator.api.ResourceGenerationContext;
import dev.lukebemish.dynamicassetgenerator.api.client.generators.TexSource;
import dev.lukebemish.dynamicassetgenerator.api.client.generators.TexSourceDataHolder;
import java.io.IOException;
import java.io.InputStream;
import java.util.Base64;
import java.util.Objects;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.IoSupplier;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

public final class TextureReaderSource
implements TexSource {
    public static final MapCodec<TextureReaderSource> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)ResourceLocation.CODEC.fieldOf("path").forGetter(TextureReaderSource::getPath)).apply((Applicative)instance, TextureReaderSource::new));
    private final ResourceLocation path;

    private TextureReaderSource(ResourceLocation path) {
        this.path = path;
    }

    @Override
    public @NonNull MapCodec<? extends TexSource> codec() {
        return CODEC;
    }

    @Override
    public IoSupplier<NativeImage> getSupplier(TexSourceDataHolder data, ResourceGenerationContext context) {
        ResourceLocation outRl = new ResourceLocation(this.getPath().getNamespace(), "textures/" + this.getPath().getPath() + ".png");
        return () -> {
            try {
                IoSupplier<InputStream> in = context.getResourceSource().getResource(outRl);
                if (in != null) {
                    return NativeImage.read((InputStream)((InputStream)in.get()));
                }
                data.getLogger().error("Texture not available in context: {}", (Object)this.getPath());
            }
            catch (IOException e) {
                String message = "Issue loading texture: " + String.valueOf(this.getPath());
                data.getLogger().error(message);
                throw new IOException(message, e);
            }
            throw new IOException("Issue loading texture: " + String.valueOf(this.getPath()));
        };
    }

    @Override
    public <T> @NonNull DataResult<T> persistentCacheData(DynamicOps<T> ops, ResourceGenerationContext context) {
        ResourceLocation outRl = new ResourceLocation(this.getPath().getNamespace(), "textures/" + this.getPath().getPath() + ".png");
        IoSupplier<InputStream> supplier = context.getResourceSource().getResource(outRl);
        if (supplier != null) {
            DataResult dataResult;
            block9: {
                InputStream is = (InputStream)supplier.get();
                try {
                    byte[] bytes = is.readAllBytes();
                    String string = Base64.getEncoder().encodeToString(bytes);
                    dataResult = DataResult.success((Object)ops.createString(string));
                    if (is == null) break block9;
                }
                catch (Throwable throwable) {
                    try {
                        if (is != null) {
                            try {
                                is.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (IOException ignored) {
                        return DataResult.error(() -> "Cannot cache potentially erroring source");
                    }
                }
                is.close();
            }
            return dataResult;
        }
        return TexSource.super.persistentCacheData(ops, context);
    }

    public ResourceLocation getPath() {
        return this.path;
    }

    public static class Builder {
        private @Nullable ResourceLocation path;

        public Builder setPath(ResourceLocation path) {
            this.path = path;
            return this;
        }

        public TextureReaderSource build() {
            Objects.requireNonNull(this.path);
            return new TextureReaderSource(this.path);
        }
    }
}

