/*
 * Decompiled with CFR 0.152.
 */
package dev.lukebemish.dynamicassetgenerator.api.client.generators;

import com.mojang.blaze3d.platform.NativeImage;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.lukebemish.dynamicassetgenerator.api.ResourceGenerationContext;
import dev.lukebemish.dynamicassetgenerator.api.ResourceGenerator;
import dev.lukebemish.dynamicassetgenerator.api.client.generators.TexSource;
import dev.lukebemish.dynamicassetgenerator.api.client.generators.TexSourceDataHolder;
import dev.lukebemish.dynamicassetgenerator.impl.DynamicAssetGenerator;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Set;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.IoSupplier;
import org.jspecify.annotations.NonNull;

public class TextureGenerator
implements ResourceGenerator {
    public static final MapCodec<TextureGenerator> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)ResourceLocation.CODEC.fieldOf("output_location").forGetter(dyn -> dyn.outputLocation), (App)TexSource.CODEC.fieldOf("input").forGetter(dyn -> dyn.input)).apply((Applicative)instance, TextureGenerator::new));
    private final ResourceLocation outputLocation;
    private final TexSource input;

    public TextureGenerator(@NonNull ResourceLocation outputLocation, @NonNull TexSource source) {
        this.input = source;
        this.outputLocation = outputLocation;
    }

    @Override
    public IoSupplier<InputStream> get(ResourceLocation outRl, ResourceGenerationContext context) {
        IoSupplier<NativeImage> imageGetter = this.input.getCachedSupplier(new TexSourceDataHolder(), context);
        if (imageGetter == null) {
            return null;
        }
        return () -> {
            ByteArrayInputStream byteArrayInputStream;
            block9: {
                NativeImage image = (NativeImage)imageGetter.get();
                try {
                    byteArrayInputStream = new ByteArrayInputStream(image.asByteArray());
                    if (image == null) break block9;
                }
                catch (Throwable throwable) {
                    try {
                        if (image != null) {
                            try {
                                image.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (IOException e) {
                        DynamicAssetGenerator.LOGGER.error("Could not write image to stream for source {}: {}", (Object)this.input.stringify(), (Object)outRl, (Object)e);
                        throw e;
                    }
                    catch (Exception remainder) {
                        DynamicAssetGenerator.LOGGER.error("Unknown issue creating texture for output {} with source {}", (Object)outRl, (Object)this.input.stringify(), (Object)remainder);
                        throw new IOException(remainder);
                    }
                }
                image.close();
            }
            return byteArrayInputStream;
        };
    }

    @Override
    public <T> @NonNull DataResult<T> persistentCacheData(DynamicOps<T> ops, ResourceLocation location, ResourceGenerationContext context) {
        return DataResult.success((Object)ops.empty());
    }

    @Override
    public @NonNull Set<ResourceLocation> getLocations(ResourceGenerationContext context) {
        return Set.of(this.getOutputLocation());
    }

    private ResourceLocation getOutputLocation() {
        return new ResourceLocation(this.outputLocation.getNamespace(), "textures/" + this.outputLocation.getPath() + ".png");
    }

    @Override
    public MapCodec<? extends ResourceGenerator> codec() {
        return CODEC;
    }
}

