/*
 * Decompiled with CFR 0.152.
 */
package dev.lukebemish.dynamicassetgenerator.impl.neoforge;

import com.google.auto.service.AutoService;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.MapCodec;
import dev.lukebemish.dynamicassetgenerator.impl.client.platform.PlatformClient;
import dev.lukebemish.dynamicassetgenerator.impl.mixin.SpriteSourcesAccessor;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.renderer.texture.atlas.SpriteSource;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.neoforge.client.event.RegisterClientReloadListenersEvent;

@AutoService(value={PlatformClient.class})
public class PlatformClientImpl
implements PlatformClient {
    private static final List<Pair<ResourceLocation, MapCodec<? extends SpriteSource>>> SPRITE_SOURCE_QUEUE = new ArrayList<Pair<ResourceLocation, MapCodec<? extends SpriteSource>>>();
    private static boolean SPRITE_SOURCES_REGISTERED = false;

    @Override
    public void addSpriteSource(ResourceLocation location, MapCodec<? extends SpriteSource> codec) {
        if (SPRITE_SOURCES_REGISTERED) {
            throw new IllegalStateException("Sprite sources have already been registered. Try registering yours during mod initialization!");
        }
        SPRITE_SOURCE_QUEUE.add((Pair<ResourceLocation, MapCodec<? extends SpriteSource>>)Pair.of((Object)location, codec));
    }

    public static void reloadListenerListener(RegisterClientReloadListenersEvent event) {
        if (SPRITE_SOURCES_REGISTERED) {
            return;
        }
        SPRITE_SOURCES_REGISTERED = true;
        for (Pair<ResourceLocation, MapCodec<? extends SpriteSource>> pair : SPRITE_SOURCE_QUEUE) {
            SpriteSourcesAccessor.dynamic_asset_generator$invokeRegister(((ResourceLocation)pair.getFirst()).toString(), (MapCodec<? extends SpriteSource>)((MapCodec)pair.getSecond()));
        }
    }
}

