/*
 * Decompiled with CFR 0.152.
 */
package dev.lukebemish.dynamicassetgenerator.impl;

import dev.lukebemish.dynamicassetgenerator.api.ResourceCache;
import dev.lukebemish.dynamicassetgenerator.impl.DynamicAssetGenerator;
import dev.lukebemish.dynamicassetgenerator.impl.util.ReentryDetector;
import java.io.InputStream;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackLocationInfo;
import net.minecraft.server.packs.PackResources;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.metadata.MetadataSectionSerializer;
import net.minecraft.server.packs.repository.Pack;
import net.minecraft.server.packs.resources.IoSupplier;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

public class GeneratedPackResources
implements PackResources {
    private final ResourceCache cache;
    private @Nullable Map<ResourceLocation, IoSupplier<InputStream>> streams;
    private final PackLocationInfo location;
    private final ReentryDetector<GetResource> getResourceDetector = new ReentryDetector();
    private final ReentryDetector<ListResources> listResourcesDetector = new ReentryDetector();
    private final ReentryDetector<PackType> getNamespacesDetector = new ReentryDetector();

    public GeneratedPackResources(PackLocationInfo location, ResourceCache cache) {
        this.cache = cache;
        this.location = location;
        cache.reset(cache.makeContext(true));
    }

    public PackLocationInfo location() {
        return this.location;
    }

    private Map<ResourceLocation, IoSupplier<InputStream>> getStreams() {
        if (this.streams == null) {
            this.streams = this.cache.getResources();
        }
        return this.streams;
    }

    public @Nullable IoSupplier<InputStream> getRootResource(String ... strings) {
        return null;
    }

    public @Nullable IoSupplier<InputStream> getResource(@NonNull PackType packType, @NonNull ResourceLocation location) {
        try (ReentryDetector.Lock lock = this.getResourceDetector.reentrant(new GetResource(packType, location));){
            if (lock.reentrant()) {
                IoSupplier<InputStream> ioSupplier = null;
                return ioSupplier;
            }
            if (packType == this.cache.getPackType() && this.getStreams().containsKey(location)) {
                IoSupplier<InputStream> ioSupplier = this.getStreams().get(location);
                return ioSupplier;
            }
            IoSupplier<InputStream> ioSupplier = null;
            return ioSupplier;
        }
    }

    public void listResources(@NonNull PackType packType, @NonNull String namespace, @NonNull String directory, // Could not load outer class - annotation placement on inner may be incorrect
    @NonNull PackResources.ResourceOutput resourceOutput) {
        try (ReentryDetector.Lock lock = this.listResourcesDetector.reentrant(new ListResources(packType, namespace, directory));){
            if (lock.reentrant()) {
                return;
            }
            if (packType == this.cache.getPackType()) {
                for (ResourceLocation key : this.getStreams().keySet()) {
                    if (!key.getPath().startsWith(directory) || !key.getNamespace().equals(namespace) || this.getStreams().get(key) == null) continue;
                    resourceOutput.accept((Object)key, this.getStreams().get(key));
                }
            }
        }
    }

    public @NonNull Set<String> getNamespaces(@NonNull PackType type) {
        try (ReentryDetector.Lock lock = this.getNamespacesDetector.reentrant(type);){
            if (lock.reentrant()) {
                Set<String> set = Set.of();
                return set;
            }
            HashSet<String> namespaces = new HashSet<String>();
            if (type == this.cache.getPackType()) {
                for (ResourceLocation key : this.getStreams().keySet()) {
                    namespaces.add(key.getNamespace());
                }
            }
            HashSet<String> hashSet = namespaces;
            return hashSet;
        }
    }

    public <T> @Nullable T getMetadataSection(MetadataSectionSerializer<T> deserializer) {
        if (deserializer.getMetadataSectionName().equals("pack")) {
            return (T)DynamicAssetGenerator.makeMetadata(this.cache);
        }
        return null;
    }

    public void close() {
    }

    private record GetResource(@NonNull PackType packType, @NonNull ResourceLocation location) {
    }

    private record ListResources(@NonNull PackType packType, @NonNull String namespace, @NonNull String directory) {
    }

    public static class GeneratedResourcesSupplier
    implements Pack.ResourcesSupplier {
        private final ResourceCache cache;

        public GeneratedResourcesSupplier(ResourceCache cache) {
            this.cache = cache;
        }

        public PackResources openPrimary(PackLocationInfo location) {
            return new GeneratedPackResources(location, this.cache);
        }

        public PackResources openFull(PackLocationInfo location, Pack.Metadata metadata) {
            return new GeneratedPackResources(location, this.cache);
        }
    }
}

