/*
 * Decompiled with CFR 0.152.
 */
package dev.lukebemish.dynamicassetgenerator.api.client;

import com.google.gson.Gson;
import com.google.gson.JsonObject;
import com.mojang.blaze3d.platform.NativeImage;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.MapCodec;
import dev.lukebemish.dynamicassetgenerator.api.ResourceGenerationContext;
import dev.lukebemish.dynamicassetgenerator.api.TrackingResourceSource;
import dev.lukebemish.dynamicassetgenerator.api.cache.CacheMetaJsonOps;
import dev.lukebemish.dynamicassetgenerator.api.client.generators.TexSource;
import dev.lukebemish.dynamicassetgenerator.api.client.generators.TexSourceDataHolder;
import dev.lukebemish.dynamicassetgenerator.api.client.generators.TextureMetaGenerator;
import dev.lukebemish.dynamicassetgenerator.impl.DynamicAssetGenerator;
import dev.lukebemish.dynamicassetgenerator.impl.ResourceCachingData;
import dev.lukebemish.dynamicassetgenerator.impl.client.ForegroundExtractor;
import dev.lukebemish.dynamicassetgenerator.impl.client.TexSourceCache;
import dev.lukebemish.dynamicassetgenerator.impl.client.platform.ClientServices;
import dev.lukebemish.dynamicassetgenerator.impl.mixin.SpriteSourcesAccessor;
import dev.lukebemish.dynamicassetgenerator.impl.util.ResourceUtils;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.minecraft.client.renderer.texture.SpriteContents;
import net.minecraft.client.renderer.texture.atlas.SpriteSource;
import net.minecraft.client.renderer.texture.atlas.SpriteSourceType;
import net.minecraft.client.resources.metadata.animation.AnimationMetadataSection;
import net.minecraft.client.resources.metadata.animation.FrameSize;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.metadata.MetadataSectionSerializer;
import net.minecraft.server.packs.resources.IoSupplier;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.ResourceMetadata;
import net.minecraft.util.GsonHelper;
import org.jetbrains.annotations.ApiStatus;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

public interface SpriteProvider<T extends SpriteProvider<T>> {
    public Map<ResourceLocation, TexSource> getSources(ResourceGenerationContext var1);

    public ResourceLocation getLocation();

    public static <T extends SpriteProvider<T>> void register(ResourceLocation location, MapCodec<T> codec) {
        ClientServices.PLATFORM_CLIENT.addSpriteSource(location, (MapCodec<? extends SpriteSource>)codec.xmap(SpriteProvider::wrap, Wrapper::unwrap));
    }

    public static <T extends SpriteProvider<T>> void register(ResourceLocation location, Supplier<T> constructor) {
        ClientServices.PLATFORM_CLIENT.addSpriteSource(location, (MapCodec<? extends SpriteSource>)MapCodec.unit(() -> ((SpriteProvider)constructor.get()).wrap()));
    }

    default public void reset(ResourceGenerationContext context) {
        TexSourceCache.reset(context);
        ForegroundExtractor.reset(context);
    }

    default public void run(final ResourceManager resourceManager, SpriteSource.Output output, final ResourceLocation cacheName) {
        ResourceGenerationContext context = new ResourceGenerationContext(){
            private final ResourceGenerationContext.ResourceSource source = ResourceGenerationContext.ResourceSource.filtered(pack -> true, PackType.CLIENT_RESOURCES, () -> ((ResourceManager)resourceManager).listPacks()).fallback(new ResourceGenerationContext.ResourceSource(){

                @Override
                public @Nullable IoSupplier<InputStream> getResource(@NonNull ResourceLocation location) {
                    return resourceManager.getResource(location).map(r -> () -> ((Resource)r).open()).orElse(null);
                }

                @Override
                public List<IoSupplier<InputStream>> getResourceStack(@NonNull ResourceLocation location) {
                    return resourceManager.getResourceStack(location).stream().map(r -> () -> ((Resource)r).open()).toList();
                }

                @Override
                public Map<ResourceLocation, IoSupplier<InputStream>> listResources(@NonNull String path, @NonNull Predicate<ResourceLocation> filter) {
                    HashMap<ResourceLocation, IoSupplier<InputStream>> map = new HashMap<ResourceLocation, IoSupplier<InputStream>>();
                    resourceManager.listResources(path, filter).forEach((rl, r) -> map.put((ResourceLocation)rl, () -> ((Resource)r).open()));
                    return map;
                }

                @Override
                public Map<ResourceLocation, List<IoSupplier<InputStream>>> listResourceStacks(@NonNull String path, @NonNull Predicate<ResourceLocation> filter) {
                    HashMap<ResourceLocation, List<IoSupplier<InputStream>>> map = new HashMap<ResourceLocation, List<IoSupplier<InputStream>>>();
                    resourceManager.listResourceStacks(path, filter).forEach((rl, r) -> map.put((ResourceLocation)rl, (List<IoSupplier<InputStream>>)r.stream().map(i -> () -> ((Resource)i).open()).toList()));
                    return map;
                }

                @Override
                public @NonNull Set<String> getNamespaces() {
                    return resourceManager.getNamespaces();
                }
            });

            @Override
            public @NonNull ResourceLocation getCacheName() {
                return cacheName;
            }

            @Override
            public ResourceGenerationContext.ResourceSource getResourceSource() {
                return this.source;
            }
        };
        this.reset(context);
        Map<ResourceLocation, TexSource> sources = this.getSources(context);
        sources.forEach((rl, texSource) -> {
            TrackingResourceSource trackingSource = TrackingResourceSource.of(context.getResourceSource(), "textures", ".png");
            ResourceGenerationContext trackingContext = context.withResourceSource(trackingSource);
            TexSourceDataHolder dataHolder = new TexSourceDataHolder();
            IoSupplier<NativeImage> imageSupplier = ResourceUtils.wrapSafeData(new ResourceLocation(rl.getNamespace(), "textures/" + rl.getPath() + ".png"), (r, c) -> texSource.getCachedSupplier(dataHolder, (ResourceGenerationContext)c), trackingContext, im -> {
                try (NativeImage image = im;){
                    ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(image.asByteArray());
                    return byteArrayInputStream;
                }
            }, is -> {
                try (InputStream input = is;){
                    NativeImage nativeImage = NativeImage.read((InputStream)input);
                    return nativeImage;
                }
            }, (r, c) -> {
                CacheMetaJsonOps ops = new CacheMetaJsonOps();
                ops.putData(ResourceCachingData.class, new ResourceCachingData((ResourceLocation)r, (ResourceGenerationContext)c));
                return TexSource.CODEC.encodeStart((DynamicOps)ops, texSource).result().map(arg_0 -> ((Gson)DynamicAssetGenerator.GSON_FLAT).toJson(arg_0)).orElse(null);
            });
            output.add(rl, spriteResourceLoader -> {
                try {
                    if (imageSupplier == null) {
                        throw new IOException("No image supplier");
                    }
                    NativeImage image = (NativeImage)imageSupplier.get();
                    AnimationMetadataSection section = AnimationMetadataSection.EMPTY;
                    if (!trackingSource.getTouchedTextures().isEmpty()) {
                        TextureMetaGenerator.AnimationGenerator generator = new TextureMetaGenerator.AnimationGenerator.Builder().build();
                        ArrayList<Pair<ResourceLocation, JsonObject>> animations = new ArrayList<Pair<ResourceLocation, JsonObject>>();
                        for (ResourceLocation touchedTexture : trackingSource.getTouchedTextures()) {
                            IoSupplier<InputStream> resource = context.getResourceSource().getResource(new ResourceLocation(touchedTexture.getNamespace(), "textures/" + touchedTexture.getPath() + ".png.mcmeta"));
                            if (resource == null) {
                                animations.add((Pair<ResourceLocation, JsonObject>)new Pair((Object)touchedTexture, null));
                                continue;
                            }
                            try (BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)resource.get()));){
                                JsonObject json = (JsonObject)DynamicAssetGenerator.GSON.fromJson((Reader)reader, JsonObject.class);
                                JsonObject animation = GsonHelper.getAsJsonObject((JsonObject)json, (String)"animation");
                                animations.add((Pair<ResourceLocation, JsonObject>)new Pair((Object)touchedTexture, (Object)animation));
                            }
                            catch (Exception ignored) {
                                animations.add((Pair<ResourceLocation, JsonObject>)new Pair((Object)touchedTexture, null));
                            }
                        }
                        JsonObject built = generator.apply(animations);
                        if (built != null) {
                            try {
                                section = AnimationMetadataSection.SERIALIZER.fromJson(built);
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                        }
                    }
                    FrameSize frameSize = new FrameSize(image.getWidth(), image.getHeight());
                    if (section != AnimationMetadataSection.EMPTY) {
                        frameSize = section.calculateFrameSize(image.getWidth(), image.getHeight());
                    }
                    return new SpriteContents(rl, frameSize, image, new ResourceMetadata.Builder().put((MetadataSectionSerializer)AnimationMetadataSection.SERIALIZER, (Object)section).build());
                }
                catch (IOException e) {
                    DynamicAssetGenerator.LOGGER.error("Failed to generate texture for sprite source type " + String.valueOf(this.getLocation()) + " at " + String.valueOf(rl) + ": ", (Throwable)e);
                    return null;
                }
            });
        });
    }

    default public Wrapper<T> wrap() {
        return new Wrapper<SpriteProvider>(this, null);
    }

    public static final class Wrapper<T extends SpriteProvider<T>>
    implements SpriteSource {
        private final T source;
        private final @Nullable ResourceLocation location;

        private Wrapper(T source, @Nullable ResourceLocation location) {
            this.source = source;
            this.location = location;
        }

        public void run(ResourceManager resourceManager, SpriteSource.Output output) {
            ResourceLocation cacheName = this.location == null ? this.source.getLocation() : this.source.getLocation().withSuffix("__" + this.location.getNamespace() + "__" + this.location.getPath());
            this.source.run(resourceManager, output, cacheName);
        }

        public @NonNull SpriteSourceType type() {
            return (SpriteSourceType)SpriteSourcesAccessor.dynamic_asset_generator$getTypes().get((Object)this.source.getLocation());
        }

        public T unwrap() {
            return this.source;
        }

        @ApiStatus.Internal
        public Wrapper<T> withLocation(ResourceLocation atlasLocation) {
            return new Wrapper<T>(this.source, atlasLocation);
        }
    }
}

