/*
 * Decompiled with CFR 0.152.
 */
package dev.lukebemish.dynamicassetgenerator.impl;

import dev.lukebemish.dynamicassetgenerator.api.ResourceCache;
import dev.lukebemish.dynamicassetgenerator.impl.DynamicAssetGenerator;
import dev.lukebemish.dynamicassetgenerator.impl.util.ReentryDetector;
import java.io.InputStream;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.minecraft.class_2960;
import net.minecraft.class_3262;
import net.minecraft.class_3264;
import net.minecraft.class_3270;
import net.minecraft.class_3288;
import net.minecraft.class_7367;
import net.minecraft.class_9224;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

public class GeneratedPackResources
implements class_3262 {
    private final ResourceCache cache;
    private @Nullable Map<class_2960, class_7367<InputStream>> streams;
    private final class_9224 location;
    private final ReentryDetector<GetResource> getResourceDetector = new ReentryDetector();
    private final ReentryDetector<ListResources> listResourcesDetector = new ReentryDetector();
    private final ReentryDetector<class_3264> getNamespacesDetector = new ReentryDetector();

    public GeneratedPackResources(class_9224 location, ResourceCache cache) {
        this.cache = cache;
        this.location = location;
        cache.reset(cache.makeContext(true));
    }

    public class_9224 method_56926() {
        return this.location;
    }

    private Map<class_2960, class_7367<InputStream>> getStreams() {
        if (this.streams == null) {
            this.streams = this.cache.getResources();
        }
        return this.streams;
    }

    public @Nullable class_7367<InputStream> method_14410(String ... strings) {
        return null;
    }

    public @Nullable class_7367<InputStream> method_14405(@NonNull class_3264 packType, @NonNull class_2960 location) {
        try (ReentryDetector.Lock lock = this.getResourceDetector.reentrant(new GetResource(packType, location));){
            if (lock.reentrant()) {
                class_7367<InputStream> class_73672 = null;
                return class_73672;
            }
            if (packType == this.cache.getPackType() && this.getStreams().containsKey(location)) {
                class_7367<InputStream> class_73673 = this.getStreams().get(location);
                return class_73673;
            }
            class_7367<InputStream> class_73674 = null;
            return class_73674;
        }
    }

    public void method_14408(@NonNull class_3264 packType, @NonNull String namespace, @NonNull String directory, // Could not load outer class - annotation placement on inner may be incorrect
    @NonNull class_3262.class_7664 resourceOutput) {
        try (ReentryDetector.Lock lock = this.listResourcesDetector.reentrant(new ListResources(packType, namespace, directory));){
            if (lock.reentrant()) {
                return;
            }
            if (packType == this.cache.getPackType()) {
                for (class_2960 key : this.getStreams().keySet()) {
                    if (!key.method_12832().startsWith(directory) || !key.method_12836().equals(namespace) || this.getStreams().get(key) == null) continue;
                    resourceOutput.accept((Object)key, this.getStreams().get(key));
                }
            }
        }
    }

    public @NonNull Set<String> method_14406(@NonNull class_3264 type) {
        try (ReentryDetector.Lock lock = this.getNamespacesDetector.reentrant(type);){
            if (lock.reentrant()) {
                Set<String> set = Set.of();
                return set;
            }
            HashSet<String> namespaces = new HashSet<String>();
            if (type == this.cache.getPackType()) {
                for (class_2960 key : this.getStreams().keySet()) {
                    namespaces.add(key.method_12836());
                }
            }
            HashSet<String> hashSet = namespaces;
            return hashSet;
        }
    }

    public <T> @Nullable T method_14407(class_3270<T> deserializer) {
        if (deserializer.method_14420().equals("pack")) {
            return (T)DynamicAssetGenerator.makeMetadata(this.cache);
        }
        return null;
    }

    public void close() {
    }

    private record GetResource(@NonNull class_3264 packType, @NonNull class_2960 location) {
    }

    private record ListResources(@NonNull class_3264 packType, @NonNull String namespace, @NonNull String directory) {
    }

    public static class GeneratedResourcesSupplier
    implements class_3288.class_7680 {
        private final ResourceCache cache;

        public GeneratedResourcesSupplier(ResourceCache cache) {
            this.cache = cache;
        }

        public class_3262 method_52424(class_9224 location) {
            return new GeneratedPackResources(location, this.cache);
        }

        public class_3262 method_52425(class_9224 location, class_3288.class_7679 metadata) {
            return new GeneratedPackResources(location, this.cache);
        }
    }
}

