/*
 * Decompiled with CFR 0.152.
 */
package dev.lukebemish.dynamicassetgenerator.api.client.generators.texsources.mask;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.lukebemish.dynamicassetgenerator.api.ResourceGenerationContext;
import dev.lukebemish.dynamicassetgenerator.api.client.generators.TexSource;
import dev.lukebemish.dynamicassetgenerator.api.client.generators.TexSourceDataHolder;
import dev.lukebemish.dynamicassetgenerator.impl.client.NativeImageHelper;
import java.util.Objects;
import net.minecraft.class_1011;
import net.minecraft.class_5253;
import net.minecraft.class_7367;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

public final class GrowMask
implements TexSource {
    private static final float DEFAULT_GROWTH = 0.0625f;
    private static final int DEFAULT_CUTOFF = 128;
    public static final MapCodec<GrowMask> CODEC = RecordCodecBuilder.mapCodec(i -> i.group((App)TexSource.CODEC.fieldOf("source").forGetter(GrowMask::getSource), (App)Codec.FLOAT.optionalFieldOf("growth", (Object)Float.valueOf(0.0625f)).forGetter(GrowMask::getGrowth), (App)Codec.INT.optionalFieldOf("cutoff", (Object)128).forGetter(GrowMask::getCutoff)).apply((Applicative)i, GrowMask::new));
    private final TexSource source;
    private final float growth;
    private final int cutoff;

    private GrowMask(TexSource source, float growth, int cutoff) {
        this.source = source;
        this.growth = growth;
        this.cutoff = cutoff;
    }

    @Override
    public @NonNull MapCodec<? extends TexSource> codec() {
        return CODEC;
    }

    @Override
    public @Nullable class_7367<class_1011> getSupplier(TexSourceDataHolder data, ResourceGenerationContext context) {
        class_7367<class_1011> input = this.source.getCachedSupplier(data, context);
        if (input == null) {
            data.getLogger().error("Texture given was nonexistent...\n{}", (Object)this.source.stringify());
            return null;
        }
        return () -> {
            try (class_1011 inImg = (class_1011)input.get();){
                int width = inImg.method_4307();
                int height = inImg.method_4323();
                int toGrow = (int)Math.floor((float)width * this.growth);
                int filterSize = toGrow * toGrow * 2 + 1;
                int[] xs = new int[filterSize];
                int[] ys = new int[filterSize];
                int counter = 0;
                for (int x = -toGrow; x <= toGrow; ++x) {
                    int y = -toGrow;
                    while (y <= toGrow) {
                        xs[counter] = x;
                        ys[counter] = y++;
                        ++counter;
                    }
                }
                class_1011 out = NativeImageHelper.of(class_1011.class_1012.field_4997, width, height, false);
                for (int x = 0; x < width; ++x) {
                    for (int y = 0; y < height; ++y) {
                        boolean shouldGrow = false;
                        for (int i : xs) {
                            for (int j : ys) {
                                int x1 = x + i;
                                int y1 = y + j;
                                if (x1 < toGrow || y1 < toGrow || x1 >= width - toGrow || y1 >= width - toGrow || class_5253.class_8045.method_48342((int)inImg.method_4315(x1, y1)) < this.cutoff) continue;
                                shouldGrow = true;
                            }
                        }
                        if (shouldGrow) {
                            out.method_4305(x, y, -1);
                            continue;
                        }
                        out.method_4305(x, y, 0);
                    }
                }
                class_1011 class_10112 = out;
                return class_10112;
            }
        };
    }

    public TexSource getSource() {
        return this.source;
    }

    public float getGrowth() {
        return this.growth;
    }

    public int getCutoff() {
        return this.cutoff;
    }

    public static class Builder {
        private TexSource source;
        private float growth = 0.0625f;
        private int cutoff = 128;

        public Builder setSource(TexSource source) {
            this.source = source;
            return this;
        }

        public Builder setGrowth(float growth) {
            this.growth = growth;
            return this;
        }

        public Builder setCutoff(int cutoff) {
            this.cutoff = cutoff;
            return this;
        }

        public GrowMask build() {
            Objects.requireNonNull(this.source);
            return new GrowMask(this.source, this.growth, this.cutoff);
        }
    }
}

