/*
 * Decompiled with CFR 0.152.
 */
package dev.lukebemish.dynamicassetgenerator.api.client.generators.texsources;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.lukebemish.dynamicassetgenerator.api.ResourceGenerationContext;
import dev.lukebemish.dynamicassetgenerator.api.client.generators.TexSource;
import dev.lukebemish.dynamicassetgenerator.api.client.generators.TexSourceDataHolder;
import dev.lukebemish.dynamicassetgenerator.api.client.image.ImageUtils;
import dev.lukebemish.dynamicassetgenerator.api.colors.ColorTypes;
import dev.lukebemish.dynamicassetgenerator.api.colors.operations.PointwiseOperation;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import net.minecraft.class_1011;
import net.minecraft.class_5253;
import net.minecraft.class_7367;
import org.jetbrains.annotations.ApiStatus;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

@ApiStatus.Experimental
public final class SpreadSource
implements TexSource {
    private static final List<Range> DEFAULT_RANGE = List.of(new Range(0, 255));
    public static final MapCodec<SpreadSource> CODEC = RecordCodecBuilder.mapCodec(i -> i.group((App)TexSource.CODEC.fieldOf("source").forGetter(SpreadSource::getSource), (App)Codec.either(Range.CODEC, (Codec)Range.CODEC.listOf()).xmap(either -> (List)either.map(List::of, Function.identity()), list -> list.size() == 1 ? Either.left((Object)((Range)list.get(0))) : Either.right((Object)list)).flatXmap(list -> {
        if (!SpreadSource.verifyDisjoint(list)) {
            return DataResult.error(() -> "Ranges must be disjoint");
        }
        return DataResult.success((Object)list);
    }, DataResult::success).optionalFieldOf("range", DEFAULT_RANGE).forGetter(SpreadSource::getRange)).apply((Applicative)i, SpreadSource::new));
    private final TexSource source;
    private final List<Range> range;

    private SpreadSource(TexSource source, List<Range> range) {
        this.source = source;
        this.range = range;
    }

    private static boolean verifyDisjoint(List<Range> ranges) {
        if (ranges.isEmpty()) {
            return false;
        }
        for (int i = 0; i < ranges.size(); ++i) {
            if (ranges.get(i).lowerBound() > ranges.get(i).upperBound()) {
                return false;
            }
            for (int j = i + 1; j < ranges.size() && j < i + 2; ++j) {
                if (ranges.get(i).upperBound() <= ranges.get(j).lowerBound()) continue;
                return false;
            }
        }
        return true;
    }

    private static int mapToRange(float value, List<Range> ranges) {
        int sum = 0;
        for (Range range : ranges) {
            sum += range.upperBound() - range.lowerBound();
        }
        int current = 0;
        for (Range range : ranges) {
            int rangeSize = range.upperBound() - range.lowerBound();
            if (value < (float)(current + rangeSize)) {
                float out = (float)range.lowerBound() + (value - (float)current) * (float)rangeSize / (float)sum;
                return ColorTypes.clamp8((int)((double)out + 0.5));
            }
            current += rangeSize;
        }
        return ranges.get(ranges.size() - 1).upperBound();
    }

    @Override
    public @NonNull MapCodec<? extends TexSource> codec() {
        return CODEC;
    }

    @Override
    public @Nullable class_7367<class_1011> getSupplier(TexSourceDataHolder data, ResourceGenerationContext context) {
        class_7367<class_1011> source = this.getSource().getCachedSupplier(data, context);
        if (source == null) {
            data.getLogger().error("Texture given was nonexistent...\n{}", (Object)this.getSource().stringify());
            return null;
        }
        return () -> {
            try (class_1011 paletteImage = (class_1011)source.get();){
                int min = 255;
                int max = 0;
                for (int i = 0; i < paletteImage.method_4307(); ++i) {
                    for (int j = 0; j < paletteImage.method_4323(); ++j) {
                        int color = paletteImage.method_4315(i, j);
                        int alpha = class_5253.class_8045.method_48342((int)color);
                        if (alpha == 0) continue;
                        int value = (class_5253.class_8045.method_48345((int)color) + class_5253.class_8045.method_48346((int)color) + class_5253.class_8045.method_48347((int)color)) / 3;
                        if (value < min) {
                            min = value;
                        }
                        if (value <= max) continue;
                        max = value;
                    }
                }
                PointwiseOperation.Unary<Integer> operation = this.createSpreadingOperation(max, min);
                class_1011 class_10112 = ImageUtils.generateScaledImage(operation, List.of(paletteImage));
                return class_10112;
            }
        };
    }

    private  @NonNull PointwiseOperation.Unary<Integer> createSpreadingOperation(int max, int min) {
        return (color, isInBounds) -> {
            int value = (class_5253.class_5254.method_27765((int)color) + class_5253.class_5254.method_27766((int)color) + class_5253.class_5254.method_27767((int)color)) / 3;
            float stretched = (float)(value - min) * 255.0f / (float)(max - min);
            int out = SpreadSource.mapToRange(stretched, this.getRange());
            return class_5253.class_5254.method_27764((int)class_5253.class_5254.method_27762((int)color), (int)out, (int)out, (int)out);
        };
    }

    public TexSource getSource() {
        return this.source;
    }

    public List<Range> getRange() {
        return this.range;
    }

    public record Range(int lowerBound, int upperBound) {
        public static final Codec<Range> CODEC = Codec.intRange((int)0, (int)255).listOf().flatXmap(list -> {
            if (list.size() != 2) {
                return DataResult.error(() -> "Range must have exactly 2 elements");
            }
            if ((Integer)list.get(1) <= (Integer)list.get(0)) {
                return DataResult.error(() -> "Second element of range must be larger than the first");
            }
            return DataResult.success((Object)new Range((Integer)list.get(0), (Integer)list.get(1)));
        }, range -> DataResult.success(List.of(Integer.valueOf(range.lowerBound()), Integer.valueOf(range.upperBound()))));
    }

    public static class Builder {
        private TexSource source;
        private List<Range> range = DEFAULT_RANGE;

        public Builder setSource(TexSource source) {
            this.source = source;
            return this;
        }

        public Builder setRange(List<Range> range) {
            this.range = range;
            return this;
        }

        public SpreadSource build() {
            Objects.requireNonNull(this.source);
            return new SpreadSource(this.source, this.range);
        }
    }
}

