/*
 * Decompiled with CFR 0.152.
 */
package dev.lukebemish.dynamicassetgenerator.api.client.generators.texsources;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.lukebemish.dynamicassetgenerator.api.ResourceGenerationContext;
import dev.lukebemish.dynamicassetgenerator.api.client.generators.TexSource;
import dev.lukebemish.dynamicassetgenerator.api.client.generators.TexSourceDataHolder;
import dev.lukebemish.dynamicassetgenerator.api.client.image.ImageUtils;
import dev.lukebemish.dynamicassetgenerator.api.colors.ColorTypes;
import dev.lukebemish.dynamicassetgenerator.api.colors.Palette;
import dev.lukebemish.dynamicassetgenerator.api.colors.operations.PointwiseOperation;
import java.util.List;
import java.util.Objects;
import net.minecraft.class_1011;
import net.minecraft.class_5253;
import net.minecraft.class_7367;
import org.jetbrains.annotations.ApiStatus;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

@ApiStatus.Experimental
public class PaletteSpreadSource
implements TexSource {
    public static final MapCodec<PaletteSpreadSource> CODEC = RecordCodecBuilder.mapCodec(i -> i.group((App)TexSource.CODEC.fieldOf("source").forGetter(PaletteSpreadSource::getSource), (App)Codec.DOUBLE.optionalFieldOf("palette_cutoff", (Object)3.5).forGetter(PaletteSpreadSource::getPaletteCutoff)).apply((Applicative)i, PaletteSpreadSource::new));
    private final TexSource source;
    private final double paletteCutoff;

    private PaletteSpreadSource(TexSource source, double paletteCutoff) {
        this.source = source;
        this.paletteCutoff = paletteCutoff;
    }

    @Override
    public @NonNull MapCodec<? extends TexSource> codec() {
        return CODEC;
    }

    @Override
    public @Nullable class_7367<class_1011> getSupplier(TexSourceDataHolder data, ResourceGenerationContext context) {
        class_7367<class_1011> source = this.getSource().getCachedSupplier(data, context);
        if (source == null) {
            data.getLogger().error("Texture given was nonexistent...\n{}", (Object)this.getSource().stringify());
            return null;
        }
        return () -> {
            try (class_1011 image = (class_1011)source.get();){
                Palette palette = ImageUtils.getPalette(image, this.getPaletteCutoff());
                PointwiseOperation.Unary<Integer> operation = (c, i) -> {
                    if (!i) {
                        return 0;
                    }
                    int alpha = ColorTypes.ARGB32.alpha(c);
                    int sample = palette.getSample(c);
                    return class_5253.class_5254.method_27764((int)alpha, (int)sample, (int)sample, (int)sample);
                };
                class_1011 class_10112 = ImageUtils.generateScaledImage(operation, List.of(image));
                return class_10112;
            }
        };
    }

    public TexSource getSource() {
        return this.source;
    }

    public double getPaletteCutoff() {
        return this.paletteCutoff;
    }

    public static class Builder {
        private TexSource source;
        private double paletteCutoff = 3.5;

        public Builder setSource(TexSource source) {
            this.source = source;
            return this;
        }

        public Builder setPaletteCutoff(double paletteCutoff) {
            this.paletteCutoff = paletteCutoff;
            return this;
        }

        public PaletteSpreadSource build() {
            Objects.requireNonNull(this.source);
            return new PaletteSpreadSource(this.source, this.paletteCutoff);
        }
    }
}

