/*
 * Decompiled with CFR 0.152.
 */
package dev.lukebemish.dynamicassetgenerator.api.client.generators.texsources;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.lukebemish.dynamicassetgenerator.api.ResourceGenerationContext;
import dev.lukebemish.dynamicassetgenerator.api.client.generators.TexSource;
import dev.lukebemish.dynamicassetgenerator.api.client.generators.TexSourceDataHolder;
import dev.lukebemish.dynamicassetgenerator.api.client.image.ImageUtils;
import dev.lukebemish.dynamicassetgenerator.api.colors.operations.ColorOperations;
import java.util.List;
import java.util.Objects;
import net.minecraft.class_1011;
import net.minecraft.class_7367;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

public final class MaskSource
implements TexSource {
    public static final MapCodec<MaskSource> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)TexSource.CODEC.fieldOf("input").forGetter(MaskSource::getInput), (App)TexSource.CODEC.fieldOf("mask").forGetter(MaskSource::getMask)).apply((Applicative)instance, MaskSource::new));
    private final TexSource input;
    private final TexSource mask;

    private MaskSource(TexSource input, TexSource mask) {
        this.input = input;
        this.mask = mask;
    }

    @Override
    public @NonNull MapCodec<? extends TexSource> codec() {
        return CODEC;
    }

    @Override
    public @Nullable class_7367<class_1011> getSupplier(TexSourceDataHolder data, ResourceGenerationContext context) {
        class_7367<class_1011> input = this.getInput().getCachedSupplier(data, context);
        class_7367<class_1011> mask = this.getMask().getCachedSupplier(data, context);
        if (input == null) {
            data.getLogger().error("Texture given was nonexistent...\n{}", (Object)this.getMask().stringify());
            return null;
        }
        if (mask == null) {
            data.getLogger().error("Texture given was nonexistent...\n{}", (Object)this.getInput().stringify());
            return null;
        }
        return () -> {
            try (class_1011 inImg = (class_1011)input.get();){
                class_1011 class_10112;
                block12: {
                    class_1011 maskImg = (class_1011)mask.get();
                    try {
                        class_10112 = ImageUtils.generateScaledImage(ColorOperations.MASK, List.of(inImg, maskImg));
                        if (maskImg == null) break block12;
                    }
                    catch (Throwable throwable) {
                        if (maskImg != null) {
                            try {
                                maskImg.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    maskImg.close();
                }
                return class_10112;
            }
        };
    }

    public TexSource getInput() {
        return this.input;
    }

    public TexSource getMask() {
        return this.mask;
    }

    public static class Builder {
        private TexSource input;
        private TexSource mask;

        public Builder setInput(TexSource input) {
            this.input = input;
            return this;
        }

        public Builder setMask(TexSource mask) {
            this.mask = mask;
            return this;
        }

        public MaskSource build() {
            Objects.requireNonNull(this.input);
            Objects.requireNonNull(this.mask);
            return new MaskSource(this.input, this.mask);
        }
    }
}

