/*
 * Decompiled with CFR 0.152.
 */
package dev.lukebemish.dynamicassetgenerator.api;

import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import dev.lukebemish.dynamicassetgenerator.impl.EmptyResourceSource;
import dev.lukebemish.dynamicassetgenerator.impl.ResourceFinder;
import dev.lukebemish.dynamicassetgenerator.impl.platform.Services;
import dev.lukebemish.dynamicassetgenerator.impl.util.InvisibleProviderUtils;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Stream;
import net.minecraft.class_2960;
import net.minecraft.class_3262;
import net.minecraft.class_3264;
import net.minecraft.class_7367;
import org.jetbrains.annotations.ApiStatus;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

public interface ResourceGenerationContext {
    public @NonNull class_2960 getCacheName();

    default public ResourceSource getResourceSource() {
        return EmptyResourceSource.INSTANCE;
    }

    @ApiStatus.NonExtendable
    default public ResourceGenerationContext withResourceSource(final ResourceSource source) {
        final ResourceGenerationContext outer = this;
        return new ResourceGenerationContext(){

            @Override
            public @NonNull class_2960 getCacheName() {
                return outer.getCacheName();
            }

            @Override
            public ResourceSource getResourceSource() {
                return source;
            }
        };
    }

    public static interface ResourceSource {
        public static ResourceSource blind() {
            return EmptyResourceSource.INSTANCE;
        }

        public @Nullable class_7367<InputStream> getResource(@NonNull class_2960 var1);

        public List<class_7367<InputStream>> getResourceStack(@NonNull class_2960 var1);

        public Map<class_2960, class_7367<InputStream>> listResources(@NonNull String var1, @NonNull Predicate<class_2960> var2);

        public Map<class_2960, List<class_7367<InputStream>>> listResourceStacks(@NonNull String var1, @NonNull Predicate<class_2960> var2);

        public @NonNull Set<String> getNamespaces();

        public static ResourceSource filtered(Predicate<String> allowedPacks, class_3264 type) {
            int ordinal = type.ordinal();
            java.util.function.Supplier<Stream<class_3262>> packs = () -> ResourceFinder.INSTANCES[ordinal].getPacks().filter(pack -> allowedPacks.test(pack.method_14409()));
            return ResourceSource.of(type, packs);
        }

        public static ResourceSource filtered(Predicate<String> allowedPacks, class_3264 type, java.util.function.Supplier<Stream<class_3262>> packResources) {
            java.util.function.Supplier<Stream<class_3262>> packs = () -> ((Stream)packResources.get()).filter(pack -> allowedPacks.test(pack.method_14409()));
            return ResourceSource.of(type, packs);
        }

        default public ResourceSource fallback(final ResourceSource fallback) {
            final ResourceSource outer = this;
            return new ResourceSource(){

                @Override
                public @Nullable class_7367<InputStream> getResource(@NonNull class_2960 location) {
                    class_7367<InputStream> supplier = outer.getResource(location);
                    return supplier != null ? supplier : fallback.getResource(location);
                }

                @Override
                public List<class_7367<InputStream>> getResourceStack(@NonNull class_2960 location) {
                    List<class_7367<InputStream>> list = outer.getResourceStack(location);
                    if (list.isEmpty()) {
                        return fallback.getResourceStack(location);
                    }
                    return list;
                }

                @Override
                public Map<class_2960, class_7367<InputStream>> listResources(@NonNull String path, @NonNull Predicate<class_2960> filter) {
                    HashMap<class_2960, class_7367<InputStream>> map = new HashMap<class_2960, class_7367<InputStream>>(fallback.listResources(path, filter));
                    map.putAll(outer.listResources(path, filter));
                    return map;
                }

                @Override
                public Map<class_2960, List<class_7367<InputStream>>> listResourceStacks(@NonNull String path, @NonNull Predicate<class_2960> filter) {
                    HashMap<class_2960, List<class_7367<InputStream>>> map = new HashMap<class_2960, List<class_7367<InputStream>>>(fallback.listResourceStacks(path, filter));
                    outer.listResourceStacks(path, filter).forEach((rl, list) -> {
                        if (!list.isEmpty()) {
                            map.put((class_2960)rl, (List<class_7367<InputStream>>)list);
                        }
                    });
                    return map;
                }

                @Override
                public @NonNull Set<String> getNamespaces() {
                    HashSet<String> set = new HashSet<String>(fallback.getNamespaces());
                    set.addAll(outer.getNamespaces());
                    return set;
                }
            };
        }

        public static ResourceSource of(class_3264 type, java.util.function.Supplier<Stream<class_3262>> resources) {
            Supplier packs = Suppliers.memoize(() -> Services.DEGROUPER.unpackPacks(Stream.concat((Stream)resources.get(), InvisibleProviderUtils.INVISIBLE_RESOURCE_PROVIDERS.stream().map(InvisibleProviderUtils::constructPlaceholderResourcesFromProvider))).toList());
            return new ResourceSource(){
                final /* synthetic */ java.util.function.Supplier val$packs;
                final /* synthetic */ class_3264 val$type;
                {
                    this.val$packs = supplier;
                    this.val$type = class_32642;
                }

                @Override
                public @Nullable class_7367<InputStream> getResource(@NonNull class_2960 location) {
                    class_7367 found = null;
                    for (class_3262 pack : (List)this.val$packs.get()) {
                        class_7367 resource = pack.method_14405(this.val$type, location);
                        if (resource == null) continue;
                        found = resource;
                    }
                    return found;
                }

                @Override
                public List<class_7367<InputStream>> getResourceStack(@NonNull class_2960 location) {
                    ArrayList<class_7367<InputStream>> out = new ArrayList<class_7367<InputStream>>();
                    for (class_3262 pack : (List)this.val$packs.get()) {
                        class_7367 resource = pack.method_14405(this.val$type, location);
                        if (resource == null) continue;
                        out.add((class_7367<InputStream>)resource);
                    }
                    Collections.reverse(out);
                    return out;
                }

                @Override
                public Map<class_2960, class_7367<InputStream>> listResources(@NonNull String path, @NonNull Predicate<class_2960> filter) {
                    HashMap<class_2960, class_7367<InputStream>> resources = new HashMap<class_2960, class_7367<InputStream>>();
                    for (class_3262 pack : (List)this.val$packs.get()) {
                        for (String namespace : pack.method_14406(this.val$type)) {
                            pack.method_14408(this.val$type, namespace, path, (rl, s) -> {
                                if (filter.test((class_2960)rl)) {
                                    resources.put((class_2960)rl, (class_7367<InputStream>)s);
                                }
                            });
                        }
                    }
                    return resources;
                }

                @Override
                public Map<class_2960, List<class_7367<InputStream>>> listResourceStacks(@NonNull String path, @NonNull Predicate<class_2960> filter) {
                    HashMap<class_2960, List<class_7367<InputStream>>> resources = new HashMap<class_2960, List<class_7367<InputStream>>>();
                    for (class_3262 pack : (List)this.val$packs.get()) {
                        for (String namespace : pack.method_14406(this.val$type)) {
                            pack.method_14408(this.val$type, namespace, path, (rl, s) -> {
                                if (filter.test((class_2960)rl)) {
                                    List list = resources.computeIfAbsent((class_2960)rl, location -> new ArrayList());
                                    list.add(s);
                                }
                            });
                        }
                    }
                    for (List list : resources.values()) {
                        Collections.reverse(list);
                    }
                    return resources;
                }

                @Override
                public @NonNull Set<String> getNamespaces() {
                    HashSet<String> namespaces = new HashSet<String>();
                    for (class_3262 pack : (List)this.val$packs.get()) {
                        namespaces.addAll(pack.method_14406(this.val$type));
                    }
                    return namespaces;
                }
            };
        }
    }
}

