/*
 * Decompiled with CFR 0.152.
 */
package dev.lukebemish.dynamicassetgenerator.api;

import dev.lukebemish.dynamicassetgenerator.api.InputStreamSource;
import dev.lukebemish.dynamicassetgenerator.api.PathAwareInputStreamSource;
import dev.lukebemish.dynamicassetgenerator.api.Resettable;
import dev.lukebemish.dynamicassetgenerator.api.ResourceGenerationContext;
import dev.lukebemish.dynamicassetgenerator.impl.DynamicAssetGenerator;
import dev.lukebemish.dynamicassetgenerator.impl.Timing;
import dev.lukebemish.dynamicassetgenerator.impl.util.ResourceUtils;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import net.minecraft.class_2960;
import net.minecraft.class_3264;
import net.minecraft.class_3288;
import net.minecraft.class_7367;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

public abstract class ResourceCache {
    protected final List<Supplier<? extends PathAwareInputStreamSource>> cache = new ArrayList<Supplier<? extends PathAwareInputStreamSource>>();
    private final List<Resettable> resetListeners = new ArrayList<Resettable>();
    private final class_2960 name;
    private @Nullable ResourceGenerationContext.ResourceSource filteredSource = null;

    public static <T extends ResourceCache> T register(T cache, class_3288.class_3289 position) {
        DynamicAssetGenerator.registerCache(cache.getName(), cache, position);
        return cache;
    }

    public Set<class_2960> getDependencies() {
        return Set.of();
    }

    public final boolean allowAccess(String packId) {
        String prefix = "dynamic_asset_generator/";
        if (!packId.startsWith(prefix)) {
            return true;
        }
        String remainder = packId.substring(prefix.length());
        class_2960 targetName = class_2960.method_29186((String)remainder).result().orElse(null);
        return targetName == null || this.getDependencies().contains(targetName);
    }

    public static <T extends ResourceCache> T register(T cache) {
        return ResourceCache.register(cache, class_3288.class_3289.field_14281);
    }

    public class_2960 getName() {
        return this.name;
    }

    public ResourceCache(class_2960 name) {
        this.name = name;
    }

    public Map<class_2960, class_7367<InputStream>> getResources() {
        HashMap<class_2960, class_7367<InputStream>> outputs = new HashMap<class_2960, class_7367<InputStream>>();
        this.cache.forEach(p -> {
            try {
                PathAwareInputStreamSource source = (PathAwareInputStreamSource)p.get();
                Set<class_2960> rls = source.getLocations(this.makeContext(false));
                if (DynamicAssetGenerator.TIME_RESOURCES) {
                    rls.forEach(rl -> {
                        long startTime = System.nanoTime();
                        class_7367<InputStream> supplier = ResourceUtils.wrapSafeData(rl, source, this.makeContext(false));
                        if (supplier != null) {
                            outputs.put((class_2960)rl, supplier);
                        }
                        long endTime = System.nanoTime();
                        long duration = (endTime - startTime) / 1000L;
                        Timing.recordPartialTime(this.getName().toString(), rl, duration);
                    });
                } else {
                    rls.forEach(rl -> {
                        class_7367<InputStream> supplier = ResourceUtils.wrapSafeData(rl, source, this.makeContext(false));
                        if (supplier != null) {
                            outputs.put((class_2960)rl, supplier);
                        }
                    });
                }
            }
            catch (Throwable e) {
                DynamicAssetGenerator.LOGGER.error("Issue setting up PathAwareInputStreamSource:", e);
            }
        });
        return outputs;
    }

    public @NonNull ResourceGenerationContext makeContext(final boolean blind) {
        return new ResourceGenerationContext(){

            @Override
            public @NonNull class_2960 getCacheName() {
                return ResourceCache.this.getName();
            }

            @Override
            public ResourceGenerationContext.ResourceSource getResourceSource() {
                if (blind || ResourceCache.this.filteredSource == null) {
                    return ResourceGenerationContext.ResourceSource.blind();
                }
                return ResourceCache.this.filteredSource;
            }
        };
    }

    public void planResetListener(Resettable listener) {
        this.resetListeners.add(listener);
    }

    public void reset(ResourceGenerationContext context) {
        this.resetListeners.forEach(r -> r.reset(context));
        this.filteredSource = ResourceGenerationContext.ResourceSource.filtered(this::allowAccess, this.getPackType());
    }

    public void planSource(class_2960 rl, InputStreamSource source) {
        this.cache.add(ResourceCache.wrap(() -> Set.of(rl), source));
    }

    public void planSource(Supplier<Set<class_2960>> locations, InputStreamSource source) {
        this.cache.add(ResourceCache.wrap(locations, source));
    }

    public void planSource(Set<class_2960> locations, InputStreamSource source) {
        this.cache.add(ResourceCache.wrap(() -> locations, source));
    }

    public void planSource(PathAwareInputStreamSource source) {
        this.cache.add(() -> source);
        if (source instanceof Resettable) {
            Resettable resettable = (Resettable)((Object)source);
            this.planResetListener(resettable);
        }
    }

    public void planSource(Supplier<? extends PathAwareInputStreamSource> source) {
        this.cache.add(source);
    }

    public abstract @NonNull class_3264 getPackType();

    private static Supplier<PathAwareInputStreamSource> wrap(final Supplier<Set<class_2960>> rls, final InputStreamSource source) {
        return () -> new PathAwareInputStreamSource(){

            @Override
            public @NonNull Set<class_2960> getLocations(ResourceGenerationContext context) {
                return (Set)rls.get();
            }

            @Override
            public class_7367<InputStream> get(class_2960 outRl, ResourceGenerationContext context) {
                return source.get(outRl, context);
            }

            @Override
            public @Nullable String createCacheKey(class_2960 outRl, ResourceGenerationContext context) {
                return source.createCacheKey(outRl, context);
            }
        };
    }
}

