package dev.lukebemish.dynamicassetgenerator.impl.mixin;

import dev.lukebemish.dynamicassetgenerator.api.client.SpriteProvider;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.ModifyVariable;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_2960;
import net.minecraft.class_3300;
import net.minecraft.class_7947;
import net.minecraft.class_7948;

@Mixin(class_7947.class)
public class SpriteSourceListMixin {
    @ModifyVariable(
        method = "load(Lnet/minecraft/server/packs/resources/ResourceManager;Lnet/minecraft/resources/ResourceLocation;)Lnet/minecraft/client/renderer/texture/atlas/SpriteSourceList;",
        at = @At(
            value = "INVOKE",
            target = "Lnet/minecraft/client/renderer/texture/atlas/SpriteSourceList;<init>(Ljava/util/List;)V",
            shift = At.Shift.BEFORE
        ),
        ordinal = 0
    )
    private static List<class_7948> dynamic_asset_generator$onLoad(List<class_7948> sources, class_3300 resourceManager, class_2960 atlasLocation) {
        List<class_7948> outSources = new ArrayList<>(sources.size());
        for (class_7948 source : sources) {
            if (source instanceof SpriteProvider.Wrapper<?> wrapper) {
                outSources.add(wrapper.withLocation(atlasLocation));
            } else {
                outSources.add(source);
            }
        }
        return outSources;
    }
}
