package dev.lukebemish.dynamicassetgenerator.impl.client;

import com.google.gson.JsonElement;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.lukebemish.dynamicassetgenerator.api.ResourceGenerationContext;
import dev.lukebemish.dynamicassetgenerator.api.client.SpriteProvider;
import dev.lukebemish.dynamicassetgenerator.api.client.generators.TexSource;
import dev.lukebemish.dynamicassetgenerator.impl.DynamicAssetGenerator;
import org.jspecify.annotations.Nullable;

import java.io.IOException;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import net.minecraft.class_2960;
import net.minecraft.class_7654;

public record BuiltinSpriteProvider(Map<class_2960, TexSource> sources, @Nullable class_2960 location) implements SpriteProvider<BuiltinSpriteProvider> {
    public static final class_2960 LOCATION = new class_2960(DynamicAssetGenerator.MOD_ID, "tex_sources");
    public static final MapCodec<BuiltinSpriteProvider> CODEC = RecordCodecBuilder.mapCodec(i -> i.group(
        Codec.unboundedMap(class_2960.field_25139, TexSource.CODEC).fieldOf("sources").forGetter(BuiltinSpriteProvider::sources),
        class_2960.field_25139.optionalFieldOf("location").forGetter(s -> Optional.ofNullable(s.location()))
    ).apply(i, (sources, location) -> new BuiltinSpriteProvider(sources, location.orElse(null))));

    @Override
    public Map<class_2960, TexSource> getSources(ResourceGenerationContext context) {
        Map<class_2960, TexSource> outSources = new HashMap<>(sources());
        if (location != null) {
            class_7654 converter = new class_7654(location.method_12836() + "/" + location.method_12832(), ".json");
            context.getResourceSource().listResources(location.method_12836() + "/" + location.method_12832(), rl -> rl.method_12832().endsWith(".json")).forEach((fileRl, resource) -> {
                class_2960 rl = converter.method_45115(fileRl);
                try (var reader = new InputStreamReader(resource.get())) {
                    JsonElement json = DynamicAssetGenerator.GSON.fromJson(reader, JsonElement.class);
                    var result = TexSource.CODEC.parse(JsonOps.INSTANCE, json);
                    result.result().ifPresent(texSource -> outSources.put(rl, texSource));
                    result.error().ifPresent(partial ->
                        DynamicAssetGenerator.LOGGER.error("Failed to load tex source json for " + location + ": " + rl + ": " + partial.message()));
                } catch (IOException e) {
                    DynamicAssetGenerator.LOGGER.error("Failed to load tex source json for " + location + ": " + rl, e);
                }
            });
        }
        return outSources;
    }

    @Override
    public class_2960 getLocation() {
        return LOCATION;
    }
}
