package dev.lukebemish.dynamicassetgenerator.impl;

import dev.lukebemish.dynamicassetgenerator.api.ResourceCache;
import dev.lukebemish.dynamicassetgenerator.impl.util.ReentryDetector;
import dev.lukebemish.dynamicassetgenerator.impl.util.ReentryDetector.Lock;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

import java.io.InputStream;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.minecraft.class_2960;
import net.minecraft.class_3262;
import net.minecraft.class_3264;
import net.minecraft.class_3270;
import net.minecraft.class_3288;
import net.minecraft.class_7367;
import net.minecraft.class_9224;

public class GeneratedPackResources implements class_3262 {

    private final ResourceCache cache;
    private @Nullable Map<class_2960, class_7367<InputStream>> streams;
    private final class_9224 location;

    public GeneratedPackResources(class_9224 location, ResourceCache cache) {
        this.cache = cache;
        this.location = location;
        cache.reset(cache.makeContext(true));
    }

    @Override
    public class_9224 method_56926() {
        return location;
    }

    private Map<class_2960, class_7367<InputStream>> getStreams() {
        if (streams == null) {
            streams = cache.getResources();
        }
        return streams;
    }

    @Nullable
    @Override
    public class_7367<InputStream> method_14410(String @NonNull ... strings) {
        return null;
    }

    @Nullable
    @Override
    public class_7367<InputStream> method_14405(@NonNull class_3264 packType, @NonNull class_2960 location) {
        try (var lock = getResourceDetector.reentrant(new GetResource(packType, location))) {
            if (lock.reentrant()) {
                return null;
            }
            if (packType == cache.getPackType()) {
                if (getStreams().containsKey(location)) {
                    return getStreams().get(location);
                }
            }
            return null;
        }
    }

    @Override
    public void method_14408(@NonNull class_3264 packType, @NonNull String namespace, @NonNull String directory, @NonNull class_7664 resourceOutput) {
        try (var lock = listResourcesDetector.reentrant(new ListResources(packType, namespace, directory))) {
            if (lock.reentrant()) {
                return;
            }
            if (packType == cache.getPackType()) {
                for (class_2960 key : getStreams().keySet()) {
                    if (key.method_12832().startsWith(directory) && key.method_12836().equals(namespace) && getStreams().get(key) != null) {
                        resourceOutput.accept(key, getStreams().get(key));
                    }
                }
            }
        }
    }

    @Override
    public @NonNull Set<String> method_14406(@NonNull class_3264 type) {
        try (var lock = getNamespacesDetector.reentrant(type)) {
            if (lock.reentrant()) {
                return Set.of();
            }
            Set<String> namespaces = new HashSet<>();
            if (type == cache.getPackType()) {
                for (class_2960 key : getStreams().keySet()) {
                    namespaces.add(key.method_12836());
                }
            }
            return namespaces;
        }
    }

    @SuppressWarnings("unchecked")
    @Nullable
    @Override
    public <T> T method_14407(class_3270<T> deserializer) {
        if (deserializer.method_14420().equals("pack")) {
            return (T) DynamicAssetGenerator.makeMetadata(cache);
        }
        return null;
    }

    @Override
    public void close() {

    }

    private record GetResource(@NonNull class_3264 packType, @NonNull class_2960 location) {}
    private final ReentryDetector<GetResource> getResourceDetector = new ReentryDetector<>();

    private record ListResources(@NonNull class_3264 packType, @NonNull String namespace, @NonNull String directory) {}
    private final ReentryDetector<ListResources> listResourcesDetector = new ReentryDetector<>();

    private final ReentryDetector<class_3264> getNamespacesDetector = new ReentryDetector<>();

    public static class GeneratedResourcesSupplier implements class_3288.class_7680 {
        private final ResourceCache cache;

        public GeneratedResourcesSupplier(ResourceCache cache) {
            this.cache = cache;
        }

        @Override
        public class_3262 method_52424(class_9224 location) {
            return new GeneratedPackResources(location, cache);
        }

        @Override
        public class_3262 method_52425(class_9224 location, class_3288.class_7679 metadata) {
            return new GeneratedPackResources(location, cache);
        }
    }
}
