package dev.lukebemish.dynamicassetgenerator.api.colors;

import com.mojang.serialization.Codec;
import org.jspecify.annotations.NonNull;

import java.util.function.IntUnaryOperator;
import net.minecraft.class_3542;

/**
 * Represents different types of color encodings, each with conversions to and from ABGR32, the format used by a
 * {@link net.minecraft.class_1011}. Meant to be used to represent encoded colors in data.
 */
public enum ColorEncoding implements class_3542 {
    ARGB("ARGB", ColorTypes.ABGR32::fromARGB32, ColorTypes.ABGR32::toARGB32),
    RGB("RGB", i -> ColorTypes.ABGR32.fromARGB32(i) | 0xFF000000, i -> ColorTypes.ABGR32.toARGB32(i) | 0xFF000000),
    ABGR("ABGR", IntUnaryOperator.identity(), IntUnaryOperator.identity()),
    BGR("BGR", i -> i | 0xFF000000, i -> i | 0xFF000000);

    public final IntUnaryOperator toABGR;
    public final IntUnaryOperator fromABGR;
    private final String name;

    ColorEncoding(String name, IntUnaryOperator toABGR, IntUnaryOperator fromABGR) {
        this.name = name;
        this.toABGR = toABGR;
        this.fromABGR = fromABGR;
    }

    @Override
    public @NonNull String method_15434() {
        return this.name;
    }

    /**
     * Codec for {@link ColorEncoding} based on its name.
     */
    public static final Codec<ColorEncoding> CODEC = class_3542.method_28140(ColorEncoding::values);
}
