package dev.lukebemish.dynamicassetgenerator.api.client.generators.texsources.mask;

import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.lukebemish.dynamicassetgenerator.api.ResourceGenerationContext;
import dev.lukebemish.dynamicassetgenerator.api.client.generators.TexSource;
import dev.lukebemish.dynamicassetgenerator.api.client.generators.TexSourceDataHolder;
import dev.lukebemish.dynamicassetgenerator.impl.client.NativeImageHelper;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

import java.util.Objects;
import net.minecraft.class_1011;
import net.minecraft.class_7367;

/**
 * A {@link TexSource} that inverts the color of a source.
 */
public final class InvertMask implements TexSource {
    public static final MapCodec<InvertMask> CODEC = RecordCodecBuilder.mapCodec(i -> i.group(
            TexSource.CODEC.fieldOf("source").forGetter(InvertMask::getSource)
    ).apply(i, InvertMask::new));
    private final TexSource source;

    private InvertMask(TexSource source) {
        this.source = source;
    }

    @Override
    public @NonNull MapCodec<? extends TexSource> codec() {
        return CODEC;
    }

    @Override
    public @Nullable class_7367<class_1011> getSupplier(TexSourceDataHolder data, ResourceGenerationContext context) {
        class_7367<class_1011> input = this.source.getCachedSupplier(data, context);
        if (input == null) {
            data.getLogger().error("Texture given was nonexistent...\n{}", this.source.stringify());
            return null;
        }
        return () -> {
            try (class_1011 inImg = input.get()) {
                int width = inImg.method_4307();
                int height = inImg.method_4323();
                class_1011 out = NativeImageHelper.of(class_1011.class_1012.field_4997, width, height, false);
                for (int x = 0; x < width; x++) {
                    for (int y = 0; y < height; y++) {
                        int source = inImg.method_4315(x, y);
                        out.method_4305(x, y, ~source);
                    }
                }
                return out;
            }
        };
    }

    public TexSource getSource() {
        return source;
    }

    public static class Builder {
        private TexSource source;

        /**
         * Sets the input texture.
         */
        public Builder setSource(TexSource source) {
            this.source = source;
            return this;
        }

        public InvertMask build() {
            Objects.requireNonNull(source);
            return new InvertMask(source);
        }
    }
}
