package dev.lukebemish.dynamicassetgenerator.api;

import org.jspecify.annotations.Nullable;

import java.io.InputStream;
import net.minecraft.class_2960;
import net.minecraft.class_7367;

/**
 * An object that can provide an input stream supplier at a given location.
 */
@FunctionalInterface
public interface InputStreamSource {
    /**
     * Gets an input stream for the given resource location.
     *
     * @param outRl   {@link class_2960} to get the input stream for.
     * @param context {@link ResourceGenerationContext} containing information about when and where the resource is being generated.
     * @return Supplier for an InputStream for the location. Should be null if the resource cannot be loaded.
     */
    @Nullable
    class_7367<InputStream> get(class_2960 outRl, ResourceGenerationContext context);

    /**
     * Create a key that can be <em>uniquely</em> used to identify the resource this generator will generate. Note that
     * this is used for caching across reloads, and so should incorporate any resources that may be used to generate the
     * resource. If this is not possible, return null.
     * @param outRl the resource location that will be generated
     * @param context the context that the resource will be generated in. Resources can safely be accessed in this context
     * @return a key that can be used to uniquely identify the resource, or null if this is not possible
     */
    default @Nullable String createCacheKey(class_2960 outRl, ResourceGenerationContext context) {
        return null;
    }
}
