/*
 * Decompiled with CFR 0.152.
 */
package dev.lukebemish.dynamicassetgenerator.api.colors.operations;

public interface PointwiseOperation<T> {
    public T apply(int[] var1, boolean[] var2);

    public int expectedImages();

    @FunctionalInterface
    public static interface Any<T>
    extends PointwiseOperation<T> {
        @Override
        default public int expectedImages() {
            return -1;
        }

        default public Unary<T> unary() {
            return (color, isInBounds) -> this.apply(new int[]{color}, new boolean[]{isInBounds});
        }

        default public Binary<T> binary() {
            return (firstColor, secondColor, isFirstInBounds, isSecondInBounds) -> this.apply(new int[]{firstColor, secondColor}, new boolean[]{isFirstInBounds, isSecondInBounds});
        }

        default public Ternary<T> ternary() {
            return (firstColor, secondColor, thirdColor, isFirstInBounds, isSecondInBounds, isThirdInBounds) -> this.apply(new int[]{firstColor, secondColor, thirdColor}, new boolean[]{isFirstInBounds, isSecondInBounds, isThirdInBounds});
        }

        public static Any<int[]> identity() {
            return (colors, inBounds) -> colors;
        }
    }

    @FunctionalInterface
    public static interface Tertiary<T>
    extends PointwiseOperation<T> {
        public T apply(int var1, int var2, int var3, int var4, boolean var5, boolean var6, boolean var7, boolean var8);

        @Override
        default public int expectedImages() {
            return 4;
        }

        @Override
        default public T apply(int[] colors, boolean[] inBounds) {
            if (colors.length != 4 || inBounds.length != 4) {
                throw new IllegalArgumentException("Ternary operation must have exactly three input images");
            }
            return this.apply(colors[0], colors[1], colors[2], colors[3], inBounds[0], inBounds[1], inBounds[2], inBounds[3]);
        }
    }

    @FunctionalInterface
    public static interface Ternary<T>
    extends PointwiseOperation<T> {
        public T apply(int var1, int var2, int var3, boolean var4, boolean var5, boolean var6);

        @Override
        default public int expectedImages() {
            return 3;
        }

        @Override
        default public T apply(int[] colors, boolean[] inBounds) {
            if (colors.length != 3 || inBounds.length != 3) {
                throw new IllegalArgumentException("Ternary operation must have exactly three input images");
            }
            return this.apply(colors[0], colors[1], colors[2], inBounds[0], inBounds[1], inBounds[2]);
        }
    }

    @FunctionalInterface
    public static interface Binary<T>
    extends PointwiseOperation<T> {
        public T apply(int var1, int var2, boolean var3, boolean var4);

        @Override
        default public int expectedImages() {
            return 2;
        }

        @Override
        default public T apply(int[] colors, boolean[] inBounds) {
            if (colors.length != 2 || inBounds.length != 2) {
                throw new IllegalArgumentException("Binary operation must have exactly two input images");
            }
            return this.apply(colors[0], colors[1], inBounds[0], inBounds[1]);
        }
    }

    @FunctionalInterface
    public static interface Unary<T>
    extends PointwiseOperation<T> {
        public T apply(int var1, boolean var2);

        @Override
        default public int expectedImages() {
            return 1;
        }

        @Override
        default public T apply(int[] colors, boolean[] inBounds) {
            if (colors.length != 1 || inBounds.length != 1) {
                throw new IllegalArgumentException("Unary operation must have exactly one input image");
            }
            return this.apply(colors[0], inBounds[0]);
        }

        public static Unary<Integer> identity() {
            return (color, isInBounds) -> color;
        }

        public static <T> Unary<T> chain(Unary<Integer> first, Unary<T> then) {
            return (color, isInBounds) -> then.apply((Integer)first.apply(color, isInBounds), isInBounds);
        }
    }
}

