/*
 * Decompiled with CFR 0.152.
 */
package dev.lukebemish.dynamicassetgenerator.api.colors.operations;

import dev.lukebemish.dynamicassetgenerator.api.colors.ColorTypes;
import dev.lukebemish.dynamicassetgenerator.api.colors.operations.PointwiseOperation;

public final class ColorOperations {
    public static final PointwiseOperation.Binary<Integer> MASK = (i, m, iInBounds, mInBounds) -> {
        if (!mInBounds || !iInBounds) {
            return 0;
        }
        int maskAlpha = ColorTypes.ARGB32.alpha(m);
        int oldAlpha = ColorTypes.ARGB32.alpha(i);
        int newAlpha = maskAlpha * oldAlpha / 255;
        return i & 0xFFFFFF | (newAlpha & 0xFF) << 24;
    };
    public static final PointwiseOperation.Any<Integer> OVERLAY = (colors, inBounds) -> {
        if (colors.length == 0) {
            return 0;
        }
        int color = 0;
        for (int i = 0; i < colors.length; ++i) {
            if (!inBounds[i]) continue;
            color = ColorTypes.ARGB32.alphaBlend(color, colors[i]);
        }
        return color;
    };
    public static final PointwiseOperation.Any<Integer> ADD = (colors, inBounds) -> {
        if (colors.length == 0) {
            return 0;
        }
        int alpha = 0;
        int red = 0;
        int green = 0;
        int blue = 0;
        for (int i = 0; i < colors.length; ++i) {
            if (!inBounds[i]) continue;
            alpha += ColorTypes.ARGB32.alpha(colors[i]);
            red += ColorTypes.ARGB32.red(colors[i]);
            green += ColorTypes.ARGB32.green(colors[i]);
            blue += ColorTypes.ARGB32.blue(colors[i]);
        }
        return ColorTypes.ARGB32.color(ColorTypes.clamp8(alpha), ColorTypes.clamp8(red), ColorTypes.clamp8(green), ColorTypes.clamp8(blue));
    };
    public static final PointwiseOperation.Any<Integer> MULTIPLY = (colors, inBounds) -> {
        if (colors.length == 0) {
            return 0;
        }
        float alpha = 255.0f;
        float red = 255.0f;
        float green = 255.0f;
        float blue = 255.0f;
        for (int i = 0; i < colors.length; ++i) {
            if (!inBounds[i]) continue;
            alpha *= (float)ColorTypes.ARGB32.alpha(colors[i]) / 255.0f;
            red *= (float)ColorTypes.ARGB32.red(colors[i]) / 255.0f;
            green *= (float)ColorTypes.ARGB32.green(colors[i]) / 255.0f;
            blue *= (float)ColorTypes.ARGB32.blue(colors[i]) / 255.0f;
        }
        alpha = Math.round(alpha);
        red = Math.round(red);
        green = Math.round(green);
        blue = Math.round(blue);
        return ColorTypes.ARGB32.color(ColorTypes.clamp8((int)alpha), ColorTypes.clamp8((int)red), ColorTypes.clamp8((int)green), ColorTypes.clamp8((int)blue));
    };
    public static final PointwiseOperation.Unary<Integer> INVERT = (color, inBounds) -> {
        if (!inBounds) {
            return 0;
        }
        return ~color;
    };

    private ColorOperations() {
    }
}

