/*
 * Decompiled with CFR 0.152.
 */
package dev.lukebemish.dynamicassetgenerator.api.sources;

import dev.lukebemish.dynamicassetgenerator.api.PathAwareInputStreamSource;
import dev.lukebemish.dynamicassetgenerator.api.Resettable;
import dev.lukebemish.dynamicassetgenerator.api.ResourceGenerationContext;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Base64;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.minecraft.class_2960;
import net.minecraft.class_7367;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

@FunctionalInterface
public interface TagSupplier
extends Function<ResourceGenerationContext, Map<class_2960, Set<class_2960>>>,
Resettable {
    default public @Nullable String createSupplierCacheKey(class_2960 outRl, ResourceGenerationContext context) {
        return null;
    }

    @Override
    default public void reset(ResourceGenerationContext context) {
    }

    public static class TagBakery
    implements PathAwareInputStreamSource,
    Resettable,
    TagSupplier {
        private Map<class_2960, Set<class_2960>> bakedTags;
        private final List<TagSupplier> tagQueue;
        private final Map<class_2960, Set<class_2960>> staticQueue = new HashMap<class_2960, Set<class_2960>>();

        public TagBakery() {
            this.tagQueue = new ArrayList<TagSupplier>();
            this.tagQueue.add(new TagSupplier(){

                @Override
                public Map<class_2960, Set<class_2960>> apply(ResourceGenerationContext context) {
                    return staticQueue;
                }

                @Override
                public String createSupplierCacheKey(class_2960 outRl, ResourceGenerationContext context) {
                    return "STATIC_QUEUE";
                }
            });
        }

        public void queue(TagSupplier tagSupplier) {
            this.tagQueue.add(tagSupplier);
        }

        public void queue(class_2960 tag, Set<class_2960> entries) {
            this.staticQueue.computeIfAbsent(tag, k -> new HashSet()).addAll(entries);
        }

        public void queue(class_2960 tag, class_2960 entry) {
            this.staticQueue.computeIfAbsent(tag, k -> new HashSet()).add(entry);
        }

        public void queue(Map<class_2960, Set<class_2960>> tags) {
            tags.forEach((tag, entries) -> this.staticQueue.computeIfAbsent((class_2960)tag, k -> new HashSet()).addAll(entries));
        }

        @Override
        public class_7367<InputStream> get(class_2960 outRl, ResourceGenerationContext context) {
            if (!outRl.method_12832().startsWith("tags/") || !outRl.method_12832().endsWith(".json")) {
                return null;
            }
            return () -> {
                this.checkTags(context);
                class_2960 tagRl = new class_2960(outRl.method_12836(), outRl.method_12832().substring(5, outRl.method_12832().length() - 5));
                return this.build(this.bakedTags.get(tagRl));
            };
        }

        private InputStream build(Set<class_2960> paths) {
            StringBuilder internal = new StringBuilder();
            ArrayList<class_2960> toAdd = new ArrayList<class_2960>(paths);
            toAdd.forEach(rl -> {
                if (!internal.isEmpty()) {
                    internal.append(",\n");
                }
                internal.append("\"").append(rl.method_12836()).append(":").append(rl.method_12832()).append("\"");
            });
            String json = "{\n\"replace\":false,\n\"values\":[" + String.valueOf(internal) + "\n]}";
            return new ByteArrayInputStream(json.getBytes());
        }

        @Override
        public @NonNull Set<class_2960> getLocations(ResourceGenerationContext context) {
            this.checkTags(context);
            return this.bakedTags.keySet().stream().map(rl -> rl.method_45138("tags/").method_48331(".json")).collect(Collectors.toSet());
        }

        @Override
        public void reset(ResourceGenerationContext context) {
            this.bakedTags = null;
            for (TagSupplier tagSupplier : this.tagQueue) {
                tagSupplier.reset(context);
            }
        }

        private synchronized void checkTags(ResourceGenerationContext context) {
            if (this.bakedTags == null) {
                this.bakedTags = new HashMap<class_2960, Set<class_2960>>();
                this.tagQueue.forEach(function -> {
                    Map map = (Map)function.apply(context);
                    map.forEach((tag, set) -> {
                        Set entrySet = this.bakedTags.computeIfAbsent((class_2960)tag, k -> new HashSet());
                        entrySet.addAll(set);
                    });
                });
            }
        }

        @Override
        public Map<class_2960, Set<class_2960>> apply(ResourceGenerationContext context) {
            this.checkTags(context);
            return this.bakedTags;
        }

        @Override
        public @Nullable String createCacheKey(class_2960 outRl, ResourceGenerationContext context) {
            StringBuilder builder = new StringBuilder();
            for (TagSupplier tagSupplier : this.tagQueue) {
                String key = tagSupplier.createSupplierCacheKey(outRl, context);
                if (key == null) {
                    return null;
                }
                builder.append(Base64.getEncoder().encodeToString(key.getBytes(StandardCharsets.UTF_8)));
                builder.append('\n');
            }
            for (Map.Entry entry : this.staticQueue.entrySet()) {
                builder.append(entry.getKey());
                builder.append("[");
                for (class_2960 rl : (Set)entry.getValue()) {
                    builder.append(rl);
                    builder.append(',');
                }
                builder.append("]\n");
            }
            return builder.substring(0, builder.length() - 1);
        }

        @Override
        public @Nullable String createSupplierCacheKey(class_2960 outRl, ResourceGenerationContext context) {
            return this.createCacheKey(outRl, context);
        }
    }
}

