/*
 * Decompiled with CFR 0.152.
 */
package dev.lukebemish.dynamicassetgenerator.api.client.generators.texsources.mask;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.lukebemish.dynamicassetgenerator.api.ResourceGenerationContext;
import dev.lukebemish.dynamicassetgenerator.api.client.generators.TexSource;
import dev.lukebemish.dynamicassetgenerator.api.client.generators.TexSourceDataHolder;
import dev.lukebemish.dynamicassetgenerator.impl.client.NativeImageHelper;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import net.minecraft.class_1011;
import net.minecraft.class_3542;
import net.minecraft.class_5253;
import net.minecraft.class_7367;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

public final class EdgeMask
implements TexSource {
    private static final int DEFAULT_CUTOFF = 128;
    private static final boolean DEFAULT_COUNT_OUTSIDE_FRAME = false;
    private static final List<Direction> DEFAULT_EDGES = Arrays.stream(Direction.values()).toList();
    public static final MapCodec<EdgeMask> CODEC = RecordCodecBuilder.mapCodec(i -> i.group((App)TexSource.CODEC.fieldOf("source").forGetter(EdgeMask::getSource), (App)Codec.BOOL.optionalFieldOf("count_outside_frame", (Object)false).forGetter(EdgeMask::isCountOutsideFrame), (App)class_3542.method_28140(Direction::values).listOf().optionalFieldOf("edges", DEFAULT_EDGES).forGetter(EdgeMask::getEdges), (App)Codec.INT.optionalFieldOf("cutoff", (Object)128).forGetter(EdgeMask::getCutoff)).apply((Applicative)i, EdgeMask::new));
    private final TexSource source;
    private final boolean countOutsideFrame;
    private final List<Direction> edges;
    private final int cutoff;

    private EdgeMask(TexSource source, boolean countOutsideFrame, List<Direction> edges, int cutoff) {
        this.source = source;
        this.countOutsideFrame = countOutsideFrame;
        this.edges = edges;
        this.cutoff = cutoff;
    }

    @Override
    public @NonNull MapCodec<? extends TexSource> codec() {
        return CODEC;
    }

    @Override
    public @Nullable class_7367<class_1011> getSupplier(TexSourceDataHolder data, ResourceGenerationContext context) {
        class_7367<class_1011> input = this.source.getCachedSupplier(data, context);
        if (input == null) {
            data.getLogger().error("Texture given was nonexistent...\n{}", (Object)this.source.stringify());
            return null;
        }
        int[] xs = this.edges.stream().mapToInt(e -> e.x).toArray();
        int[] ys = this.edges.stream().mapToInt(e -> e.y).toArray();
        return () -> {
            try (class_1011 inImg = (class_1011)input.get();){
                int width = inImg.method_4307();
                int height = inImg.method_4323();
                class_1011 out = NativeImageHelper.of(class_1011.class_1012.field_4997, width, height, false);
                for (int x = 0; x < width; ++x) {
                    for (int y = 0; y < height; ++y) {
                        boolean isEdge = false;
                        int color = inImg.method_4315(x, y);
                        if (class_5253.class_8045.method_48342((int)color) >= this.cutoff) {
                            for (int i = 0; i < xs.length; ++i) {
                                int x1 = xs[i] + x;
                                int y1 = ys[i] + y;
                                if ((!this.countOutsideFrame || x1 >= 0 && y1 >= 0 && x1 <= width - 1 && y1 <= width - 1) && class_5253.class_8045.method_48342((int)inImg.method_4315(x1, y1)) >= this.cutoff) continue;
                                isEdge = true;
                            }
                        }
                        if (isEdge) {
                            out.method_4305(x, y, -1);
                            continue;
                        }
                        out.method_4305(x, y, 0);
                    }
                }
                class_1011 class_10112 = out;
                return class_10112;
            }
        };
    }

    public TexSource getSource() {
        return this.source;
    }

    public boolean isCountOutsideFrame() {
        return this.countOutsideFrame;
    }

    public List<Direction> getEdges() {
        return this.edges;
    }

    public int getCutoff() {
        return this.cutoff;
    }

    public static enum Direction implements class_3542
    {
        NORTH(0, -1),
        NORTHEAST(1, -1),
        EAST(1, 0),
        SOUTHEAST(1, 1),
        SOUTH(0, 1),
        SOUTHWEST(-1, 1),
        WEST(-1, 0),
        NORTHWEST(-1, -1);

        public final int x;
        public final int y;

        private Direction(int x, int y) {
            this.x = x;
            this.y = y;
        }

        public @NonNull String method_15434() {
            return this.name().toLowerCase(Locale.ROOT);
        }
    }

    public static class Builder {
        private TexSource source;
        private boolean countOutsideFrame = false;
        private List<Direction> edges = DEFAULT_EDGES;
        private int cutoff = 128;

        public Builder setSource(TexSource source) {
            this.source = source;
            return this;
        }

        public Builder setCountOutsideFrame(boolean countOutsideFrame) {
            this.countOutsideFrame = countOutsideFrame;
            return this;
        }

        public Builder setEdges(List<Direction> edges) {
            this.edges = edges;
            return this;
        }

        public Builder setCutoff(int cutoff) {
            this.cutoff = cutoff;
            return this;
        }

        public EdgeMask build() {
            Objects.requireNonNull(this.source);
            return new EdgeMask(this.source, this.countOutsideFrame, this.edges, this.cutoff);
        }
    }
}

