/*
 * Decompiled with CFR 0.152.
 */
package dev.lukebemish.dynamicassetgenerator.api.client.generators.texsources;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.lukebemish.dynamicassetgenerator.api.ResourceGenerationContext;
import dev.lukebemish.dynamicassetgenerator.api.client.generators.TexSource;
import dev.lukebemish.dynamicassetgenerator.api.client.generators.TexSourceDataHolder;
import java.io.IOException;
import java.util.Objects;
import net.minecraft.class_1011;
import net.minecraft.class_7367;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;
import org.slf4j.helpers.NOPLogger;

public final class FallbackSource
implements TexSource {
    public static final MapCodec<FallbackSource> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)TexSource.CODEC.fieldOf("original").forGetter(FallbackSource::getOriginal), (App)TexSource.CODEC.fieldOf("fallback").forGetter(FallbackSource::getFallback)).apply((Applicative)instance, FallbackSource::new));
    private final TexSource original;
    private final TexSource fallback;

    private FallbackSource(TexSource original, TexSource fallback) {
        this.original = original;
        this.fallback = fallback;
    }

    @Override
    public @NonNull MapCodec<? extends TexSource> codec() {
        return CODEC;
    }

    @Override
    public @Nullable class_7367<class_1011> getSupplier(TexSourceDataHolder data, ResourceGenerationContext context) {
        TexSourceDataHolder newData = new TexSourceDataHolder(data);
        newData.put(TexSourceDataHolder.LOGGER_TOKEN, NOPLogger.NOP_LOGGER);
        class_7367<class_1011> original = this.getOriginal().getCachedSupplier(newData, context);
        class_7367<class_1011> fallback = this.getFallback().getCachedSupplier(data, context);
        if (original == null && fallback == null) {
            data.getLogger().error("Both textures given were nonexistent...");
            return null;
        }
        return () -> {
            if (original != null) {
                try {
                    return (class_1011)original.get();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            if (fallback != null) {
                return (class_1011)fallback.get();
            }
            data.getLogger().error("Both textures given were unloadable...");
            throw new IOException("Both textures given were unloadable...");
        };
    }

    public TexSource getOriginal() {
        return this.original;
    }

    public TexSource getFallback() {
        return this.fallback;
    }

    public static class Builder {
        private TexSource original;
        private TexSource fallback;

        public Builder setOriginal(TexSource original) {
            this.original = original;
            return this;
        }

        public Builder setFallback(TexSource fallback) {
            this.fallback = fallback;
            return this;
        }

        public FallbackSource build() {
            Objects.requireNonNull(this.original);
            Objects.requireNonNull(this.fallback);
            return new FallbackSource(this.original, this.fallback);
        }
    }
}

