/*
 * Decompiled with CFR 0.152.
 */
package dev.lukebemish.dynamicassetgenerator.api.client.generators.texsources;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.lukebemish.dynamicassetgenerator.api.ResourceGenerationContext;
import dev.lukebemish.dynamicassetgenerator.api.client.generators.TexSource;
import dev.lukebemish.dynamicassetgenerator.api.client.generators.TexSourceDataHolder;
import dev.lukebemish.dynamicassetgenerator.api.client.image.ImageUtils;
import dev.lukebemish.dynamicassetgenerator.impl.client.NativeImageHelper;
import java.io.IOException;
import java.util.Objects;
import net.minecraft.class_1011;
import net.minecraft.class_7367;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

public final class CropSource
implements TexSource {
    public static final MapCodec<CropSource> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.INT.fieldOf("total_size").forGetter(CropSource::getTotalSize), (App)Codec.INT.fieldOf("start_x").forGetter(CropSource::getStartX), (App)Codec.INT.fieldOf("size_x").forGetter(CropSource::getSizeX), (App)Codec.INT.fieldOf("start_y").forGetter(CropSource::getStartY), (App)Codec.INT.fieldOf("size_y").forGetter(CropSource::getSizeY), (App)TexSource.CODEC.fieldOf("input").forGetter(CropSource::getInput)).apply((Applicative)instance, CropSource::new));
    private final int totalSize;
    private final int startX;
    private final int sizeX;
    private final int startY;
    private final int sizeY;
    private final TexSource input;

    private CropSource(int totalSize, int startX, int sizeX, int startY, int sizeY, TexSource input) {
        this.totalSize = totalSize;
        this.startX = startX;
        this.sizeX = sizeX;
        this.startY = startY;
        this.sizeY = sizeY;
        this.input = input;
    }

    @Override
    public @NonNull MapCodec<? extends TexSource> codec() {
        return CODEC;
    }

    @Override
    public @Nullable class_7367<class_1011> getSupplier(TexSourceDataHolder data, ResourceGenerationContext context) {
        class_7367<class_1011> suppliedInput = this.getInput().getCachedSupplier(data, context);
        if (suppliedInput == null) {
            data.getLogger().error("Texture given was nonexistent...\n{}", (Object)this.getInput().stringify());
            return null;
        }
        if (this.getSizeX() < 0 || this.getSizeY() < 0) {
            data.getLogger().error("Bounds of image are negative...\n{}", (Object)this.stringify());
            return null;
        }
        if (this.getTotalSize() <= 0) {
            data.getLogger().error("Total image width must be positive");
            return null;
        }
        return () -> {
            try (class_1011 inImg = (class_1011)suppliedInput.get();){
                int scale = inImg.method_4307() / this.getTotalSize();
                if (scale == 0) {
                    data.getLogger().error("Image scale turned out to be 0! Image is {} wide, total width is {}", (Object)inImg.method_4307(), (Object)this.getTotalSize());
                    throw new IOException("Image scale turned out to be 0! Image is " + inImg.method_4307() + " wide, total width is " + this.getTotalSize());
                }
                int distX = this.getSizeX() * scale;
                int distY = this.getSizeY() * scale;
                if (distY < 1 || distX < 1) {
                    data.getLogger().error("Bounds of image are non-positive! {}, {}", (Object)this.getSizeX(), (Object)this.getSizeY());
                    throw new IOException("Bounds of image are non-positive! " + this.getSizeX() + ", " + this.getSizeY());
                }
                class_1011 out = NativeImageHelper.of(class_1011.class_1012.field_4997, distX, distY, false);
                for (int x = 0; x < distX; ++x) {
                    for (int y = 0; y < distY; ++y) {
                        int c = ImageUtils.safeGetPixelABGR(inImg, x + this.getStartX() * scale, y + this.getStartY() * scale);
                        out.method_4305(x, y, c);
                    }
                }
                class_1011 class_10112 = out;
                return class_10112;
            }
        };
    }

    public int getTotalSize() {
        return this.totalSize;
    }

    public int getStartX() {
        return this.startX;
    }

    public int getSizeX() {
        return this.sizeX;
    }

    public int getStartY() {
        return this.startY;
    }

    public int getSizeY() {
        return this.sizeY;
    }

    public TexSource getInput() {
        return this.input;
    }

    public static class Builder {
        private int totalSize;
        private int startX;
        private int sizeX;
        private int startY;
        private int sizeY;
        private TexSource input;

        public Builder setTotalSize(int totalSize) {
            this.totalSize = totalSize;
            return this;
        }

        public Builder setStartX(int startX) {
            this.startX = startX;
            return this;
        }

        public Builder setSizeX(int sizeX) {
            this.sizeX = sizeX;
            return this;
        }

        public Builder setStartY(int startY) {
            this.startY = startY;
            return this;
        }

        public Builder setSizeY(int sizeY) {
            this.sizeY = sizeY;
            return this;
        }

        public Builder setInput(TexSource input) {
            this.input = input;
            return this;
        }

        public CropSource build() {
            Objects.requireNonNull(this.input);
            return new CropSource(this.totalSize, this.startX, this.sizeX, this.startY, this.sizeY, this.input);
        }
    }
}

