package dev.lukebemish.dynamicassetgenerator.impl.util;

import ;
import dev.lukebemish.dynamicassetgenerator.api.compat.ConditionalInvisibleResourceProvider;
import dev.lukebemish.dynamicassetgenerator.api.compat.InvisibleResourceProvider;
import dev.lukebemish.dynamicassetgenerator.impl.DynamicAssetGenerator;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

import java.io.InputStream;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.stream.Stream;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3262;
import net.minecraft.class_3264;
import net.minecraft.class_3270;
import net.minecraft.class_5352;
import net.minecraft.class_7367;
import net.minecraft.class_9224;

public final class InvisibleProviderUtils {
    public static final List<InvisibleResourceProvider> INVISIBLE_RESOURCE_PROVIDERS =
            Stream.concat(
                    ServiceLoader.load(InvisibleResourceProvider.class).stream()
                            .map(ServiceLoader.Provider::get),
                    ServiceLoader.load(ConditionalInvisibleResourceProvider.class).stream()
                            .map(ServiceLoader.Provider::get)
                            .filter(ConditionalInvisibleResourceProvider::isAvailable)
                            .map(ConditionalInvisibleResourceProvider::get)
            ).toList();

    static {
        DynamicAssetGenerator.LOGGER.debug("Loaded invisible resource providers: {}", InvisibleProviderUtils.INVISIBLE_RESOURCE_PROVIDERS);
    }

    private InvisibleProviderUtils() {}

    public static class_3262 constructPlaceholderResourcesFromProvider(InvisibleResourceProvider provider) {
        return new class_3262() {
            @Nullable
            @Override
            public class_7367<InputStream> method_14410(String @NonNull ... strings) {
                return null;
            }

            @Override
            public class_7367<InputStream> method_14405(@NonNull class_3264 type, @NonNull class_2960 location) {
                return provider.getResource(type, location);
            }

            @Override
            public void method_14408(@NonNull class_3264 packType, @NonNull String namespace, @NonNull String path, @NonNull class_7664 resourceOutput) {
                provider.listResources(packType, namespace, path, resourceOutput);
            }

            @Override
            public @NonNull Set<String> method_14406(@NonNull class_3264 type) {
                return provider.getNamespaces(type);
            }

            @Nullable
            @Override
            public <T> T method_14407(@NonNull class_3270<T> deserializer) {
                return null;
            }

            @Override
            public class_9224 method_56926() {
                var codePoints = provider.getClass().getName()
                    .toLowerCase(Locale.ROOT)
                    .codePoints().map(i -> Character.isJavaIdentifierPart(i) ? i : '_')
                    .toArray();
                return new class_9224(
                    "__placeholder/"+new String(codePoints, 0, codePoints.length),
                    class_2561.method_43473(),
                    class_5352.field_25347,
                    Optional.empty()
                );
            }

            @Override
            public void close() {}
        };
    }
}
