package dev.lukebemish.dynamicassetgenerator.impl.fabriquilt.fabric;

import java.util.ArrayList;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.class_3264;
import net.minecraft.class_3285;
import net.minecraft.class_3288;

public class PackPlanner {
    private static final Map<class_3264, PackPlanner> PLANNERS = new IdentityHashMap<>();

    private final List<class_3285> sources = new ArrayList<>();

    public void register(class_3285 consumer) {
        sources.add(consumer);
    }

    public static PackPlanner forType(class_3264 type) {
        return PLANNERS.computeIfAbsent(type, t -> new PackPlanner());
    }

    public List<class_3288> plan() {
        List<class_3288> packs = new ArrayList<>();
        for (class_3285 source : sources) {
            source.method_14453(packs::add);
        }
        return packs;
    }
}
